/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.utils.lang.Immutable;
import org.eclipse.scada.utils.str.StringHelper;

@Immutable
public class DataItemInformationBase
implements DataItemInformation {
    private final String id;
    private final Set<IODirection> ioDirection;

    public DataItemInformationBase(String id, Set<IODirection> ioDirection) {
        this.id = id;
        this.ioDirection = EnumSet.copyOf(ioDirection);
    }

    public DataItemInformationBase(String id) {
        this.id = id;
        this.ioDirection = EnumSet.allOf(IODirection.class);
    }

    public DataItemInformationBase(DataItemInformation information) {
        this.id = information.getName();
        this.ioDirection = EnumSet.copyOf(information.getIODirection());
    }

    public Set<IODirection> getIODirection() {
        return this.ioDirection;
    }

    public String getName() {
        return this.id;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataItemInformationBase other = (DataItemInformationBase)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return String.format("[%s, %s]", this.id, StringHelper.join(this.ioDirection, (String)", "));
    }
}

