/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.item.factory;

import java.util.ArrayList;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.chain.WriteHandlerItem;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.CommonItemFactory;

public class HiveItemFactory
extends CommonItemFactory {
    protected HiveCommon hive;

    public HiveItemFactory(HiveCommon hive) {
        super(hive.getOperationService());
        this.hive = hive;
    }

    public HiveItemFactory(CommonItemFactory parentItemFactory, HiveCommon hive, String baseId, String idDelimiter) {
        super(hive.getOperationService(), parentItemFactory, baseId, idDelimiter);
        this.hive = hive;
    }

    @Override
    protected DataItemCommand constructCommand(String localId) {
        DataItemCommand item = super.constructCommand(localId);
        this.hive.registerItem(item);
        return item;
    }

    @Override
    protected WriteHandlerItem constructWriteHandler(String localId, WriteHandler writeHandler) {
        WriteHandlerItem item = super.constructWriteHandler(localId, writeHandler);
        this.hive.registerItem(item);
        return item;
    }

    @Override
    protected DataItemInputChained constructInput(String localId) {
        DataItemInputChained item = super.constructInput(localId);
        this.hive.registerItem(item);
        return item;
    }

    @Override
    protected WriteHandlerItem constructInputOutput(String localId, WriteHandler writeHandler) {
        WriteHandlerItem item = super.constructInputOutput(localId, writeHandler);
        this.hive.registerItem(item);
        return item;
    }

    @Override
    public void disposeItem(DataItem item) {
        super.disposeItem(item);
        this.hive.unregisterItem(item);
    }

    @Override
    public void disposeAllItems() {
        for (DataItem item : new ArrayList(this.itemMap.values())) {
            this.hive.unregisterItem(item);
        }
        super.disposeAllItems();
    }
}

