/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.event.proxy;

import java.util.List;
import java.util.concurrent.locks.Lock;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.event.proxy.ProxyEventQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractEventQueryListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEventQueryListener.class);
    protected final Lock lock;
    private final ProxyEventQuery proxyEventQuery;
    protected final String info;
    private boolean disposed;

    public AbstractEventQueryListener(ProxyEventQuery proxyEventQuery, Lock lock, String info) {
        this.lock = lock;
        this.proxyEventQuery = proxyEventQuery;
        this.info = info;
    }

    protected void addEvents(List<Event> events) {
        if (events == null) {
            return;
        }
        logger.debug("adding events: {}", (Object)events.size());
        this.lock.lock();
        try {
            if (this.disposed) {
                logger.info("We are disposed. Discard event");
                return;
            }
            this.proxyEventQuery.addEvents(events);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void dispose() {
        this.lock.lock();
        try {
            this.disposed = true;
        }
        finally {
            this.lock.unlock();
        }
    }
}

