/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.event.proxy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.common.event.AbstractEventQueryImpl;
import org.eclipse.scada.ae.server.event.proxy.LocalEventQueryListener;
import org.eclipse.scada.ae.server.event.proxy.RemoteEventQueryListener;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyEventQuery
extends AbstractEventQueryImpl {
    private static final Logger logger = LoggerFactory.getLogger(ProxyEventQuery.class);
    private final Map<String, RemoteEventQueryListener> remoteListenerMap = new HashMap<String, RemoteEventQueryListener>();
    private final Map<String, LocalEventQueryListener> localListenerMap = new HashMap<String, LocalEventQueryListener>();
    private final BundleContext context;
    private final Lock lock = new ReentrantLock();

    public ProxyEventQuery(BundleContext context, Executor executor, int poolSize, Map<String, String> parameters) throws Exception {
        super(executor, poolSize);
        this.context = context;
        this.update(parameters);
    }

    public void dispose() {
        this.lock.lock();
        logger.info("Disposing");
        try {
            for (RemoteEventQueryListener remoteEventQueryListener : this.remoteListenerMap.values()) {
                remoteEventQueryListener.dispose();
            }
            this.remoteListenerMap.clear();
            for (LocalEventQueryListener localEventQueryListener : this.localListenerMap.values()) {
                localEventQueryListener.dispose();
            }
            this.localListenerMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void update(Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        HashSet<String> remoteQueryStrings = new HashSet<String>();
        for (Map.Entry query : cfg.getPrefixed("remote.queries.").entrySet()) {
            remoteQueryStrings.add((String)query.getValue());
        }
        HashSet<String> localQueryStrings = new HashSet<String>();
        for (Map.Entry query : cfg.getPrefixed("local.queries.").entrySet()) {
            localQueryStrings.add((String)query.getValue());
        }
        this.lock.lock();
        try {
            this.setRemoteQueries(remoteQueryStrings);
            this.setLocalQueries(localQueryStrings);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setLocalQueries(Set<String> queryStrings) throws InvalidSyntaxException {
        HashSet<String> current = new HashSet<String>(this.localListenerMap.keySet());
        current.removeAll(queryStrings);
        for (String queryString : current) {
            LocalEventQueryListener queryListener = this.localListenerMap.remove(queryString);
            if (queryListener == null) continue;
            logger.info("Disposing query: {}", (Object)queryString);
            queryListener.dispose();
        }
        for (String queryString : queryStrings) {
            logger.info("Adding query: {}", (Object)queryString);
            LocalEventQueryListener MonitorQueryListener = this.createLocalQueryListener(queryString);
            this.localListenerMap.put(queryString, MonitorQueryListener);
        }
    }

    private void setRemoteQueries(Set<String> queryStrings) {
        HashSet<String> current = new HashSet<String>(this.remoteListenerMap.keySet());
        current.removeAll(queryStrings);
        for (String queryString : current) {
            RemoteEventQueryListener queryListener = this.remoteListenerMap.remove(queryString);
            if (queryListener == null) continue;
            logger.info("Disposing query: {}", (Object)queryString);
            queryListener.dispose();
        }
        for (String queryString : queryStrings) {
            logger.info("Adding query: {}", (Object)queryString);
            String[] tok = queryString.split("#", 2);
            RemoteEventQueryListener MonitorQueryListener = this.createQueryListener(tok[0], tok[1]);
            this.remoteListenerMap.put(queryString, MonitorQueryListener);
        }
    }

    private RemoteEventQueryListener createQueryListener(String connectionId, String monitorQueryId) {
        return new RemoteEventQueryListener(this.context, connectionId, monitorQueryId, this, this.lock);
    }

    private LocalEventQueryListener createLocalQueryListener(String monitorQueryId) throws InvalidSyntaxException {
        return new LocalEventQueryListener(this.context, monitorQueryId, this, this.lock);
    }

    public void addEvents(List<Event> events) {
        logger.debug("Adding events: {}", (Object)events.size());
        this.addEvents(events, null);
    }
}

