/*******************************************************************************
 * Copyright (c) 2014 IBH SYSTEMS GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBH SYSTEMS GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.scada.da.server.exporter.common;

import org.eclipse.scada.da.core.server.Hive;

public class StaticHiveSource implements HiveSource
{
    private final Hive hive;

    public StaticHiveSource ( final Hive hive )
    {
        this.hive = hive;
    }

    @Override
    public void addListener ( final HiveSourceListener listener )
    {
        listener.setHive ( this.hive );
    }

    @Override
    public void removeListener ( final HiveSourceListener listener )
    {
    }
}
