/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.net;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.ae.data.BrowserEntry;
import org.eclipse.scada.ae.data.BrowserType;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;

public class BrowserMessageHelper {
    public static List<BrowserEntry> fromValue(Value baseValue) {
        if (!(baseValue instanceof ListValue)) {
            return null;
        }
        ArrayList<BrowserEntry> result = new ArrayList<BrowserEntry>();
        ListValue value = (ListValue)baseValue;
        for (Value entryValue : value.getValues()) {
            BrowserEntry entry = BrowserMessageHelper.fromValueEntry(entryValue);
            if (entry == null) continue;
            result.add(entry);
        }
        return result;
    }

    private static Set<BrowserType> getTypes(Value value) {
        EnumSet<BrowserType> result = EnumSet.noneOf(BrowserType.class);
        if (value instanceof ListValue) {
            for (Value entry : ((ListValue)value).getValues()) {
                BrowserType type;
                if (!(entry instanceof StringValue)) continue;
                String strValue = ((StringValue)entry).getValue();
                if (strValue == "CONDITIONS") {
                    strValue = "MONITORS";
                }
                if ((type = BrowserType.valueOf((String)strValue)) == null) continue;
                result.add(type);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private static BrowserEntry fromValueEntry(Value entryValue) {
        Value attributes;
        Set<BrowserType> types;
        String id;
        block7: {
            MapValue value;
            block6: {
                if (!(entryValue instanceof MapValue)) {
                    return null;
                }
                value = (MapValue)entryValue;
                id = ((StringValue)value.get("id")).getValue();
                types = BrowserMessageHelper.getTypes(value.get("types"));
                if (types != null) break block6;
                return null;
            }
            attributes = value.get("attributes");
            if (attributes instanceof MapValue) break block7;
            return null;
        }
        try {
            return new BrowserEntry(id, types, MessageHelper.mapToAttributes((MapValue)((MapValue)attributes)));
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Value toValue(List<BrowserEntry> added) {
        ListValue result = new ListValue();
        if (added != null) {
            for (BrowserEntry entry : added) {
                result.add(BrowserMessageHelper.toValue(entry));
            }
        }
        return result;
    }

    private static Value toValue(BrowserEntry entry) {
        MapValue value = new MapValue();
        value.put("id", (Value)new StringValue(entry.getId()));
        ListValue types = new ListValue();
        for (BrowserType type : entry.getTypes()) {
            types.add((Value)new StringValue(type.toString()));
        }
        value.put("types", (Value)types);
        value.put("attributes", (Value)MessageHelper.attributesToMap((Map)entry.getAttributes()));
        return value;
    }

    public static Value toValue(Set<String> removed) {
        if (removed == null) {
            return VoidValue.INSTANCE;
        }
        ListValue result = new ListValue();
        for (String entry : removed) {
            result.add((Value)new StringValue(entry));
        }
        return result;
    }

    public static Set<String> fromValueRemoved(Value value) {
        if (!(value instanceof ListValue)) {
            return null;
        }
        HashSet<String> removed = new HashSet<String>();
        for (Value entryValue : ((ListValue)value).getValues()) {
            if (!(entryValue instanceof StringValue)) continue;
            removed.add(((StringValue)entryValue).getValue());
        }
        return removed;
    }
}

