/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.event.proxy;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.server.common.event.EventQuery;
import org.eclipse.scada.ae.server.event.proxy.ProxyEventQuery;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.sec.UserInformation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyEventQueryFactory
extends AbstractServiceConfigurationFactory<ProxyEventQuery> {
    private static final Logger logger = LoggerFactory.getLogger(ProxyEventQueryFactory.class);
    public static final String FACTORY_ID = "org.eclipse.scada.ae.server.event.proxy";
    private final Executor executor;

    public ProxyEventQueryFactory(BundleContext context, Executor executor) {
        super(context, true);
        this.executor = executor;
    }

    protected AbstractServiceConfigurationFactory.Entry<ProxyEventQuery> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        logger.info("Creating new proxy query: {}", (Object)configurationId);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        int poolSize = cfg.getIntegerChecked("poolSize", "'poolSize' must be set");
        if (poolSize <= 0) {
            throw new IllegalArgumentException("'poolSize' must be a positive integer greater zero");
        }
        ProxyEventQuery service = new ProxyEventQuery(context, this.executor, poolSize, parameters);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", configurationId);
        ServiceRegistration handle = context.registerService(EventQuery.class, (Object)service, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)service, handle);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, ProxyEventQuery service) {
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<ProxyEventQuery> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<ProxyEventQuery> entry, Map<String, String> parameters) throws Exception {
        return null;
    }
}

