/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.buffer.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.buffer.BufferedDataSource;
import org.eclipse.scada.da.buffer.BufferedDataSourceListener;
import org.eclipse.scada.da.buffer.internal.Persistence;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.eclipse.scada.da.datasource.data.DataItemValueLight;
import org.eclipse.scada.da.datasource.data.DataItemValueRange;
import org.eclipse.scada.ds.DataListener;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.DataNodeTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.osgi.pool.SingleObjectPoolServiceTracker;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedDataSourceImpl
implements BufferedDataSource,
DataListener,
DataSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(BufferedDataSourceImpl.class);
    private final BundleContext context;
    private final ScheduledExecutorService scheduler;
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final DataNodeTracker dataNodeTracker;
    private final String configurationId;
    private final ObjectPoolImpl<BufferedDataSource> objectPool;
    private String dataSourceId;
    private Variant initialValue;
    private long trigger;
    private long range;
    private DataItemValueRange valueRange;
    private String nodeId;
    private boolean triggerOnly;
    private Persistence persistence;
    private final Set<BufferedDataSourceListener> listeners = new CopyOnWriteArraySet<BufferedDataSourceListener>();
    private final Object listenersLock = new Object();
    private ScheduledFuture<?> triggerFuture;
    private boolean initialPersistentValuesLoaded = false;
    private SingleObjectPoolServiceTracker<DataSource> dataSourceTracker;
    private DataSource dataSource;

    public BufferedDataSourceImpl(BundleContext context, ScheduledExecutorService scheduler, ObjectPoolTracker<DataSource> poolTracker, DataNodeTracker dataNodeTracker, String configurationId, ObjectPoolImpl<BufferedDataSource> objectPool) {
        this.context = context;
        this.scheduler = scheduler;
        this.poolTracker = poolTracker;
        this.dataNodeTracker = dataNodeTracker;
        this.configurationId = configurationId;
        this.objectPool = objectPool;
    }

    public void update(Map<String, String> parameters) {
        logger.info("Update configuration");
        if (this.triggerFuture != null) {
            this.triggerFuture.cancel(false);
            this.triggerFuture = null;
        }
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.dataSourceId = cfg.getStringChecked("datasource.id", String.format("'%s' must be set", "datasource.id"));
        this.initialValue = cfg.getVariant("initialValue", Variant.NULL);
        this.trigger = cfg.getLongChecked("trigger", "'trigger' must be set");
        this.range = cfg.getLongChecked("range", "'range' must be set");
        this.triggerOnly = cfg.getBoolean("triggerOnly", false);
        this.persistence = (Persistence)cfg.getEnum("persistence", Persistence.class, (Enum)Persistence.NONE);
        this.valueRange = new DataItemValueRange(this.range);
        this.valueRange.add(new DataItemValueLight(this.initialValue, SubscriptionState.CONNECTED, 0L, false, false));
        this.nodeId = cfg.getString("node.id", "org.eclipse.scada.da.buffer/" + this.dataSourceId + "/" + this.range);
        this.triggerFuture = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedDataSourceImpl.this.valueRange.checkRange();
                    BufferedDataSourceImpl.this.sendUpdate(true);
                }
                catch (Exception e) {
                    logger.error("failed to run checkRange () or call handleChange ()", (Throwable)e);
                }
            }
        }, this.trigger, this.trigger, TimeUnit.SECONDS);
        this.dataSourceTracker = new SingleObjectPoolServiceTracker(this.poolTracker, this.dataSourceId, (SingleObjectPoolServiceTracker.ServiceListener)new SingleObjectPoolServiceTracker.ServiceListener<DataSource>(){

            public void serviceChange(DataSource service, Dictionary<?, ?> properties) {
                BufferedDataSourceImpl.this.setDataSource(service);
            }
        });
        this.dataSourceTracker.open();
        if (this.persistence != Persistence.REQUIRED) {
            this.dataNodeTracker.addListener(this.nodeId, (DataListener)this);
            this.addService();
        }
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                BufferedDataSourceImpl.this.valueRange.checkRange();
                BufferedDataSourceImpl.this.sendUpdate(false);
            }
        });
    }

    private synchronized void setDataSource(DataSource service) {
        if (service == null && this.dataSource != null) {
            this.dataSource.removeListener((DataSourceListener)this);
        } else {
            this.dataSource = service;
            this.dataSource.addListener((DataSourceListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.removeService();
        this.setDataSource(null);
        if (this.dataNodeTracker != null) {
            this.dataNodeTracker.removeListener(this.nodeId, (DataListener)this);
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    public void nodeChanged(DataNode node) {
        if (this.initialPersistentValuesLoaded) {
            return;
        }
        try {
            SortedSet initialValues = null;
            if (node != null) {
                initialValues = (SortedSet)node.getDataAsObject(this.context.getBundle());
            }
            this.initialPersistentValuesLoaded = true;
            if (initialValues != null) {
                for (DataItemValueLight dataItemValue : initialValues) {
                    this.valueRange.add(dataItemValue);
                }
            }
            if (this.persistence == Persistence.REQUIRED) {
                this.addService();
            }
        }
        catch (Exception e) {
            logger.warn("could not load old persistent values", (Throwable)e);
        }
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                BufferedDataSourceImpl.this.sendUpdate(false);
            }
        });
    }

    public void stateChanged(DataItemValue value) {
        logger.debug("State changed - value: {}", (Object)value);
        this.valueRange.add(DataItemValueLight.valueOf((DataItemValue)value));
        if (this.persistence != Persistence.NONE) {
            logger.trace("Storing update");
            DataItemValueRange.DataItemValueRangeState state = this.valueRange.getState();
            TreeSet<DataItemValueLight> valuesToPersist = new TreeSet<DataItemValueLight>();
            valuesToPersist.add(state.getFirstValue());
            valuesToPersist.addAll(state.getValues());
            this.dataNodeTracker.write(new DataNode(this.nodeId, valuesToPersist));
        }
        logger.trace("Sending update");
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                BufferedDataSourceImpl.this.sendUpdate(false);
            }
        });
    }

    private void sendUpdate(boolean triggered) {
        logger.debug("sendUpdate - triggered: {}, dataSource: {}, persistence: {}, initialPersistentValuesLoaded: {}, triggerOnly: {}", new Object[]{triggered, this.dataSource, this.persistence, this.initialPersistentValuesLoaded, this.triggerOnly});
        if (this.dataSource == null) {
            return;
        }
        if (this.persistence == Persistence.REQUIRED && !this.initialPersistentValuesLoaded) {
            return;
        }
        if (this.triggerOnly && triggered || !this.triggerOnly) {
            for (BufferedDataSourceListener listener : this.listeners) {
                try {
                    listener.stateChanged(this.valueRange);
                }
                catch (Exception e) {
                    logger.info("Failed to call listener", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(BufferedDataSourceListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(BufferedDataSourceListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    private void addService() {
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put("buffered.datasource.id", this.configurationId);
        this.objectPool.addService(this.configurationId, (Object)this, properties);
    }

    private void removeService() {
        this.objectPool.removeService(this.configurationId, (Object)this);
    }
}

