/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.totalizer;

import java.io.Serializable;
import java.util.Date;

public class TotalizerState
implements Serializable {
    private static final long serialVersionUID = -6420717271346060602L;
    private final long timestamp;
    private final double total;

    public TotalizerState(long timestamp, double total) {
        this.timestamp = timestamp;
        this.total = total;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public double getTotal() {
        return this.total;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        long temp = Double.doubleToLongBits(this.total);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TotalizerState other = (TotalizerState)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return Double.doubleToLongBits(this.total) == Double.doubleToLongBits(other.total);
    }

    public String toString() {
        return "TotalizerState [timestamp=" + this.timestamp + "(" + new Date(this.timestamp) + ",) total=" + this.total + "]";
    }
}

