/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.osgi.factory;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.DataItemBaseChained;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.item.ChainCreator;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleObjectExporter<T> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleObjectExporter.class);
    private final Class<? extends T> objectClass;
    private final ItemFactory factory;
    private final String prefix;
    private final Map<String, DataItemInputChained> itemMap = new HashMap<String, DataItemInputChained>();

    public SimpleObjectExporter(Class<? extends T> objectClass, ItemFactory factory, String prefix) {
        this.objectClass = objectClass;
        this.factory = factory;
        this.prefix = prefix;
        this.createFields();
        this.setValue(null);
    }

    public void setValue(T value) {
        this.setValue(value, false);
    }

    /*
     * Unable to fully structure code
     */
    public void setValue(T value, boolean forceTimestamp) {
        block8: {
            timestamp = forceTimestamp != false ? Long.valueOf(System.currentTimeMillis()) : null;
            try {
                bi = Introspector.getBeanInfo(this.objectClass);
                var8_6 = bi.getPropertyDescriptors();
                var7_7 = var8_6.length;
                var6_8 = 0;
                while (var6_8 < var7_7) {
                    pd = var8_6[var6_8];
                    item = this.itemMap.get(pd.getName());
                    if (value != null) {
                        try {
                            data = pd.getReadMethod().invoke(value, new Object[0]);
                            this.setItemValue(pd, item, data, timestamp);
                        }
                        catch (Exception e) {
                            this.setItemError(pd, item, e);
                        }
                    } else {
                        this.setItemError(pd, item, null);
                    }
                    ++var6_8;
                }
                break block8;
            }
            catch (Exception e) {
                SimpleObjectExporter.logger.warn("Failed to set value");
                ** for (item : this.itemMap.values())
            }
lbl-1000:
            // 1 sources

            {
                this.setItemError(null, item, e);
                continue;
            }
        }
    }

    private void setItemError(PropertyDescriptor pd, DataItemInputChained item, Exception e) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        if (pd != null) {
            this.fillAttributes(pd, attributes);
        }
        if (e != null) {
            attributes.put("invocation.error", Variant.TRUE);
            attributes.put("invocation.error.message", Variant.valueOf((Object)e.getMessage()));
        } else {
            attributes.put("null.error", Variant.TRUE);
        }
        item.updateData(Variant.NULL, attributes, AttributeMode.SET);
    }

    private void fillAttributes(PropertyDescriptor pd, Map<String, Variant> attributes) {
        attributes.put("property.name", Variant.valueOf((Object)pd.getName()));
        attributes.put("property.type", Variant.valueOf((Object)pd.getPropertyType().getName()));
    }

    private void setItemValue(PropertyDescriptor pd, DataItemInputChained item, Object data, Long timestamp) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        this.fillAttributes(pd, attributes);
        if (timestamp != null) {
            attributes.put("timestamp", Variant.valueOf((Object)timestamp));
        }
        item.updateData(Variant.valueOf((Object)data), attributes, AttributeMode.SET);
    }

    private void createFields() {
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.objectClass);
            PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (pd.getReadMethod() != null) {
                    this.createDataItem(pd);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to create fields", (Throwable)e);
        }
    }

    private void createDataItem(PropertyDescriptor pd) {
        String name = pd.getName();
        HashMap<String, Variant> properties = new HashMap<String, Variant>();
        if (pd.getShortDescription() != null) {
            properties.put("description", Variant.valueOf((Object)pd.getShortDescription()));
        } else {
            properties.put("description", Variant.valueOf((Object)("Field: " + pd.getName())));
        }
        DataItemInputChained item = this.factory.createInput(String.valueOf(this.prefix) + "." + name, properties);
        ChainCreator.applyDefaultInputChain((DataItemBaseChained)item);
        this.itemMap.put(name, item);
    }
}

