/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.browser.common.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.DataItem;

public class ItemDescriptor {
    private final Map<String, Variant> attributes;
    private final DataItem item;
    private final String itemId;

    public ItemDescriptor(DataItem item, Map<String, Variant> attributes) {
        this.item = item;
        this.itemId = item.getInformation().getName();
        this.attributes = attributes != null ? new HashMap<String, Variant>(attributes) : Collections.emptyMap();
    }

    public Map<String, Variant> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public DataItem getItem() {
        return this.item;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemDescriptor)) {
            return false;
        }
        ItemDescriptor other = (ItemDescriptor)obj;
        return !(this.itemId == null ? other.itemId != null : !this.itemId.equals(other.itemId));
    }
}

