/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.iec60870;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.ValidationStrategy;
import org.eclipse.scada.da.server.common.osgi.AbstractOsgiHiveCommon;
import org.eclipse.scada.da.server.iec60870.Connection;
import org.eclipse.scada.da.server.iec60870.ConnectionConfiguration;
import org.eclipse.scada.da.server.iec60870.cfg.CAConfigurationFactory;
import org.eclipse.scada.da.server.iec60870.cfg.ConfigurationFactory;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive
extends AbstractOsgiHiveCommon {
    private static final Logger logger = LoggerFactory.getLogger(Hive.class);
    private final ConfigurationFactory.Receiver configurationReceiver = new ConfigurationFactory.Receiver(){

        @Override
        public void removeConnection(String id) {
            Hive.this.performRemoveConnection(id);
        }

        @Override
        public ListenableFuture<Void> addConnection(String id, ConnectionConfiguration configuration) {
            return Hive.this.performAddConnection(id, configuration);
        }
    };
    private final ConfigurationFactory factory;
    private ExportedExecutorService executor;
    private final Map<String, Connection> connections = new HashMap<String, Connection>();
    private final FolderCommon rootFolder;

    public Hive() {
        this(new CAConfigurationFactory(FrameworkUtil.getBundle(Hive.class).getBundleContext()), FrameworkUtil.getBundle(Hive.class).getBundleContext());
    }

    public Hive(ConfigurationFactory factory, BundleContext context) {
        super(context);
        this.factory = factory;
        this.setValidatonStrategy(ValidationStrategy.GRANT_ALL);
        this.rootFolder = new FolderCommon();
        this.setRootFolder((Folder)this.rootFolder);
    }

    FolderCommon getRootFolder() {
        return this.rootFolder;
    }

    protected void performStart() throws Exception {
        this.executor = new ExportedExecutorService(Hive.class.getName(), 0, 1, 1L, TimeUnit.MINUTES);
        super.performStart();
        this.factory.setReceiver(this.configurationReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performStop() throws Exception {
        this.factory.setReceiver(null);
        super.performStop();
        ExportedExecutorService service = null;
        Hive hive = this;
        synchronized (hive) {
            if (this.executor != null) {
                service = this.executor;
                this.executor.shutdown();
                this.executor = null;
            }
        }
        if (service != null) {
            service.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
    }

    public String getHiveId() {
        return Hive.class.getPackage().getName();
    }

    protected synchronized ListenableFuture<Void> performAddConnection(final String id, final ConnectionConfiguration configuration) {
        logger.debug("adding connection - id: {}, cfg: {}", (Object)id, (Object)configuration);
        if (this.executor == null) {
            logger.debug("Hive is not started");
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Hive is not started"));
        }
        ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Hive.this.handleAddConnection(id, configuration);
                }
                catch (Exception e) {
                    logger.warn("Failed to create connection", (Throwable)e);
                    throw new InvocationTargetException(e);
                }
                return null;
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRemoveConnection(final String id) {
        Hive hive = this;
        synchronized (hive) {
            if (this.executor == null) {
                return;
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Hive.this.handleRemoveConnection(id);
                }
            });
        }
    }

    protected synchronized void handleAddConnection(String id, ConnectionConfiguration configuration) {
        logger.debug("Handling: add connection, id: {}, cfg: {}", (Object)id, (Object)configuration);
        Connection old = this.connections.remove(id);
        if (old != null) {
            old.dispose();
        }
        this.connections.put(id, new Connection(id, this, (Executor)this.executor, configuration));
    }

    protected synchronized void handleRemoveConnection(String id) {
        logger.debug("Handling: remove connection, id: {}", (Object)id);
        Connection connection = this.connections.remove(id);
        if (connection != null) {
            connection.dispose();
        }
    }
}

