/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.summary;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.server.osgi.summary.AbstractDataSourceSummarizer;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.str.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeDataSourceSummarizer
extends AbstractDataSourceSummarizer {
    private static final Logger logger = LoggerFactory.getLogger(AttributeDataSourceSummarizer.class);
    private final Set<DataSource> matchingSources = new HashSet<DataSource>();
    private final DataItemValue.Builder countValue = new DataItemValue.Builder();
    private String attributeName;
    private boolean onlyMaster;
    private HashSet<String> blacklist;

    public AttributeDataSourceSummarizer(Executor executor, ObjectPoolTracker<DataSource> tracker) {
        super(executor, tracker);
        this.countValue.setSubscriptionState(SubscriptionState.CONNECTED);
        this.countValue.setValue(Variant.valueOf((int)0));
        this.updateData(this.countValue.build());
    }

    @Override
    protected void handleAdding(DataSource source) {
    }

    @Override
    protected synchronized void handleRemoved(DataSource source) {
        if (this.matchingSources.remove(source)) {
            this.updateStats();
        }
    }

    @Override
    protected synchronized void handleStateChange(DataSource source, DataItemValue value) {
        if (this.isMatch(source, value)) {
            if (this.matchingSources.add(source)) {
                this.updateStats();
            }
        } else if (this.matchingSources.remove(source)) {
            this.updateStats();
        }
    }

    @Override
    protected boolean isMatch(DataSource source, Dictionary<?, ?> properties) {
        Object pid = properties.get("service.pid");
        if (!(pid instanceof String)) {
            logger.debug("Rejecting datasource - invalid service.pid - {}", pid);
            return false;
        }
        if (!(source instanceof MasterItem) && this.onlyMaster) {
            logger.debug("Rejecting datasource ({}) - class {} but we require master items ", pid, source.getClass());
            return false;
        }
        if (this.blacklist.contains(pid)) {
            logger.debug("Rejecting datasource ({}) - service.pid is blacklisted", pid);
            return false;
        }
        return true;
    }

    protected boolean isMatch(DataSource source, DataItemValue value) {
        if (!(source instanceof MasterItem) && this.onlyMaster) {
            return false;
        }
        if (value == null) {
            return false;
        }
        if (value.getAttributes() == null) {
            return false;
        }
        Variant attrValue = (Variant)value.getAttributes().get(this.attributeName);
        if (attrValue == null) {
            return false;
        }
        return attrValue.asBoolean();
    }

    protected void updateStats() {
        int count = this.matchingSources.size();
        logger.debug("Update size: {}", (Object)count);
        this.countValue.setValue(Variant.valueOf((int)count));
        if (count < 10) {
            this.countValue.setAttribute("debug.info", Variant.valueOf((Object)StringHelper.join(this.matchingSources, (String)",")));
        } else {
            this.countValue.clearAttribute("debug.info");
        }
        this.updateData(this.countValue.build());
    }

    public void dispose() {
        this.close();
    }

    public void update(Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.close();
        this.attributeName = cfg.getStringChecked("attribute", "'attribute' must be set");
        this.onlyMaster = cfg.getBoolean("onlyMaster", false);
        this.blacklist = new HashSet(cfg.getPrefixed("blacklist.").values());
        this.open();
    }
}

