/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.proxy.configuration.ConfigurationPackage;
import org.eclipse.scada.da.server.proxy.configuration.RootType;
import org.eclipse.scada.da.server.proxy.configuration.XMLConfigurator;
import org.eclipse.scada.da.server.proxy.configuration.util.ConfigurationResourceFactoryImpl;
import org.eclipse.scada.da.server.proxy.connection.ProxyConnection;
import org.eclipse.scada.da.server.proxy.utils.ProxyPrefixName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive
extends HiveCommon {
    private static final Logger logger = LoggerFactory.getLogger(Hive.class);
    private final FolderCommon rootFolder;
    private final Map<ProxyPrefixName, ProxyConnection> connections = new HashMap<ProxyPrefixName, ProxyConnection>();
    private boolean initialized = false;
    private String separator = ".";
    private FolderCommon connectionsFolder;
    private final XMLConfigurator configurator;

    public Hive() throws IOException {
        this(new XMLConfigurator(Hive.parse(URI.createFileURI((String)"configuration.xml"))));
    }

    public Hive(String uri) throws IOException {
        this(new XMLConfigurator(Hive.parse(URI.createURI((String)uri))));
    }

    public Hive(XMLConfigurator configurator) {
        this.configurator = configurator;
        this.rootFolder = new FolderCommon();
        this.setRootFolder((Folder)this.rootFolder);
    }

    public Hive(RootType root) throws Exception {
        this(new XMLConfigurator(root));
    }

    private static RootType parse(URI uri) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ConfigurationResourceFactoryImpl());
        Resource r = rs.createResource(uri);
        r.load(null);
        return (RootType)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)ConfigurationPackage.Literals.ROOT_TYPE);
    }

    public String getHiveId() {
        return "org.eclipse.scada.da.server.proxy";
    }

    public ProxyConnection addConnection(ProxyPrefixName prefix) {
        if (this.initialized) {
            throw new IllegalArgumentException("no further connections may be added when initialize() was already called!");
        }
        if (this.connections.keySet().contains(prefix)) {
            throw new IllegalArgumentException("prefix must not already exist!");
        }
        ProxyConnection connection = new ProxyConnection(this, prefix, this.connectionsFolder);
        this.connections.put(prefix, connection);
        return connection;
    }

    protected void performStart() throws Exception {
        super.performStart();
        logger.info("Starting hive");
        this.connectionsFolder = new FolderCommon();
        this.rootFolder.add("connections", (Folder)this.connectionsFolder, new HashMap());
        if (this.configurator != null) {
            this.configurator.configure(this);
        }
        for (ProxyConnection connection : this.connections.values()) {
            connection.start();
        }
        this.initialized = true;
    }

    protected void performStop() throws Exception {
        for (ProxyConnection connection : this.connections.values()) {
            connection.stop();
        }
        super.performStop();
    }

    public void setSeparator(String separator) {
        if (this.initialized) {
            throw new IllegalArgumentException("separator may not be changed when initialize() was already called!");
        }
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }
}

