/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.mina;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.eclipse.scada.net.base.data.BooleanValue;
import org.eclipse.scada.net.base.data.DoubleValue;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;
import org.eclipse.scada.net.codec.InvalidValueTypeException;
import org.eclipse.scada.net.mina.GMPPProtocol;

public class GMPPProtocolEncoder
implements ProtocolEncoder,
GMPPProtocol {
    private final ThreadLocal<CharsetEncoder> encoderLocal = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Charset.forName("utf-8").newEncoder();
        }
    };

    public void dispose(IoSession session) throws Exception {
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        if (message instanceof Message) {
            out.write((Object)this.code((Message)message));
        } else if (message instanceof IoBuffer && !((IoBuffer)message).hasRemaining()) {
            System.err.println("Empty buffer");
            out.write(message);
        } else {
            throw new IllegalArgumentException("Protocol encoder can only handle messages of type 'Message'");
        }
    }

    private void encodeToStream(IoBuffer buffer, String data) {
        buffer.putInt(0);
        int pos = buffer.position();
        try {
            buffer.putString((CharSequence)data, this.encoderLocal.get());
            int afterPos = buffer.position();
            int len = afterPos - pos;
            buffer.putInt(pos - 4, len);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Failed to encode", e);
        }
    }

    private void encodeToStream(IoBuffer buffer, IntegerValue value) {
        buffer.putInt(5);
        buffer.putInt(4);
        buffer.putInt(value.value);
    }

    private void encodeToStream(IoBuffer buffer, LongValue value) {
        buffer.putInt(2);
        buffer.putInt(8);
        buffer.putLong(value.getValue());
    }

    private void encodeToStream(IoBuffer buffer, DoubleValue value) {
        buffer.putInt(3);
        buffer.putInt(8);
        buffer.putLong(Double.doubleToRawLongBits(value.getValue()));
    }

    private void encodeToStream(IoBuffer buffer, VoidValue value) {
        buffer.putInt(4);
        buffer.putInt(0);
    }

    private void encodeToStream(IoBuffer buffer, BooleanValue value) {
        buffer.putInt(8);
        buffer.putInt(1);
        buffer.put(value.getValue() ? (byte)-1 : 0);
    }

    private void encodeToStream(IoBuffer buffer, StringValue value) {
        buffer.putInt(1);
        this.encodeToStream(buffer, value.getValue());
    }

    private void encodeToStream(IoBuffer buffer, ListValue value) throws InvalidValueTypeException {
        buffer.putInt(6);
        int position = buffer.position();
        buffer.putInt(0);
        int startPos = buffer.position();
        buffer.putInt(value.getValues().size());
        for (Value valueEntry : value.getValues()) {
            this.codeValue(buffer, valueEntry);
        }
        int size = buffer.position() - startPos;
        buffer.putInt(position, size);
    }

    private void encodeToStream(IoBuffer buffer, MapValue value) throws InvalidValueTypeException {
        buffer.putInt(7);
        int position = buffer.position();
        buffer.putInt(0);
        int startPos = buffer.position();
        buffer.putInt(value.getValues().size());
        for (Map.Entry<String, Value> valueEntry : value.getValues().entrySet()) {
            this.codeValue(buffer, valueEntry.getKey(), valueEntry.getValue());
        }
        int size = buffer.position() - startPos;
        buffer.putInt(position, size);
    }

    private void codeValue(IoBuffer buffer, Value value) throws InvalidValueTypeException {
        if (value == null) {
            throw new NullPointerException("Trying to encode a 'null' value. Use VoidValue instead!");
        }
        Class<?> clazz = value.getClass();
        if (clazz == StringValue.class) {
            this.encodeToStream(buffer, (StringValue)value);
        } else if (clazz == BooleanValue.class) {
            this.encodeToStream(buffer, (BooleanValue)value);
        } else if (clazz == IntegerValue.class) {
            this.encodeToStream(buffer, (IntegerValue)value);
        } else if (clazz == LongValue.class) {
            this.encodeToStream(buffer, (LongValue)value);
        } else if (clazz == DoubleValue.class) {
            this.encodeToStream(buffer, (DoubleValue)value);
        } else if (clazz == VoidValue.class) {
            this.encodeToStream(buffer, (VoidValue)value);
        } else if (clazz == ListValue.class) {
            this.encodeToStream(buffer, (ListValue)value);
        } else if (clazz == MapValue.class) {
            this.encodeToStream(buffer, (MapValue)value);
        } else {
            throw new InvalidValueTypeException(String.format("The type '%s' is unknown", value.getClass().getName()));
        }
    }

    private void codeValue(IoBuffer buffer, String name, Value value) throws InvalidValueTypeException {
        this.codeValue(buffer, value);
        this.encodeToStream(buffer, name);
    }

    public IoBuffer code(Message message) throws InvalidValueTypeException {
        IoBuffer outputBuffer = IoBuffer.allocate((int)32);
        outputBuffer.setAutoExpand(true);
        outputBuffer.clear();
        outputBuffer.putInt(message.getCommandCode());
        outputBuffer.putLong(message.getTimestamp());
        outputBuffer.putLong(message.getSequence());
        outputBuffer.putLong(message.getReplySequence());
        int sizePos = outputBuffer.position();
        outputBuffer.putInt(0);
        int startPos = outputBuffer.position();
        this.codeValue(outputBuffer, message.getValues());
        int bodySize = outputBuffer.position() - startPos;
        outputBuffer.putInt(sizePos, bodySize);
        outputBuffer.flip();
        return outputBuffer;
    }
}

