/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.master.hds;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.hd.server.common.StorageHistoricalItem;
import org.eclipse.scada.hd.server.storage.hds.AbstractStorageImpl;
import org.eclipse.scada.hds.DataFilePool;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageImpl
extends AbstractStorageImpl
implements StorageHistoricalItem {
    private static final Logger logger = LoggerFactory.getLogger(StorageImpl.class);
    private final ScheduledExecutorService updateExecutor;
    private final ServiceRegistration<StorageHistoricalItem> handle;
    private final ScheduledFuture<?> heartbeatJob;
    private final int heartbeatFrequency = Integer.getInteger("org.eclipse.scada.hd.server.storage.hds.heartbeatFrequency", 3);

    public StorageImpl(File file, BundleContext context, DataFilePool pool, ScheduledExecutorService queryExecutor, ScheduledExecutorService updateExecutor, ScheduledExecutorService eventExecutor) throws Exception {
        super(file, pool, queryExecutor, eventExecutor);
        this.updateExecutor = updateExecutor;
        this.heartbeatJob = updateExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                StorageImpl.this.heartbeat();
            }
        }, 0L, this.getHeartbeatPeriod(), TimeUnit.MILLISECONDS);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.pid", this.id);
        this.handle = context.registerService(StorageHistoricalItem.class, (Object)this, properties);
    }

    protected void heartbeat() {
        final Date now = new Date();
        FutureTask task = new FutureTask(new Runnable(){

            @Override
            public void run() {
                try {
                    StorageImpl.this.handleHearbeat(now);
                }
                catch (Exception exception) {
                    logger.warn("Failed to insert heartbeat");
                }
            }
        }, null);
        task.addListener((FutureListener)new FutureListener<Void>(){

            public void complete(Future<Void> future) {
                StorageImpl.this.removeJob(future);
            }
        });
        this.addJob(task);
        this.updateExecutor.submit((Runnable)task);
    }

    private long getHeartbeatPeriod() {
        return this.nativeLevel.getTimeSlice() / (long)Math.max(this.heartbeatFrequency, 2);
    }

    public void dispose() {
        if (this.heartbeatJob != null) {
            this.heartbeatJob.cancel(false);
        }
        this.handle.unregister();
        super.dispose();
    }

    public void updateData(DataItemValue value) {
        block12: {
            logger.debug("Received value update: {}", (Object)value);
            this.readLock.lock();
            try {
                double dValue;
                if (value == null) {
                    this.updateData(Double.NaN, new Date(), true, false);
                    break block12;
                }
                Variant variant = value.getValue();
                if (variant.isNull()) {
                    dValue = Double.NaN;
                } else if (variant.isNumber()) {
                    dValue = variant.asDouble(Double.valueOf(Double.NaN));
                } else if (variant.isBoolean()) {
                    dValue = variant.asBoolean() ? 1.0 : 0.0;
                } else {
                    try {
                        dValue = Double.parseDouble(variant.asString(null));
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Failed to convert %s", variant), (Throwable)e);
                        dValue = Double.NaN;
                    }
                }
                Calendar timestamp = value.getTimestamp() == null ? Calendar.getInstance() : value.getTimestamp();
                this.updateData(dValue, timestamp.getTime(), Double.isNaN(dValue) ? true : value.isError(), value.isManual());
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    protected void updateData(double value, Date timestamp, boolean error, boolean manual) {
        FutureTask task = new FutureTask((Runnable)new UpdateJob(value, timestamp, error, manual), null);
        task.addListener((FutureListener)new FutureListener<Void>(){

            public void complete(Future<Void> future) {
                StorageImpl.this.removeJob(future);
            }
        });
        this.addJob(task);
        this.updateExecutor.submit((Runnable)task);
    }

    private void performInsert(double value, Date timestamp, boolean error, boolean manual) {
        logger.debug("Requesting insert - value: {}, timestamp: {}, error: {}, manual: {}", new Object[]{value, timestamp, error, manual});
        try {
            this.nativeLevel.insertValue(value, timestamp, error, manual);
            this.notifyData(value, timestamp, error, manual);
        }
        catch (Exception e) {
            logger.error("Failed to insert HD data", (Throwable)e);
        }
    }

    public void purge() {
        logger.info("Purging native level");
        this.nativeLevel.purge();
    }

    private void handleHearbeat(Date now) throws Exception {
        this.nativeLevel.insertHeartbeat(now);
        this.purge();
    }

    private class UpdateJob
    implements Runnable {
        private final double value;
        private final Date timestamp;
        private final boolean error;
        private final boolean manual;

        public UpdateJob(double value, Date timestamp, boolean error, boolean manual) {
            this.value = value;
            this.timestamp = timestamp;
            this.error = error;
            this.manual = manual;
        }

        @Override
        public void run() {
            StorageImpl.this.performInsert(this.value, this.timestamp, this.error, this.manual);
        }
    }
}

