/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.http.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.handler.InjectionContext;
import org.eclipse.scada.ae.server.http.internal.EventSerializer;
import org.eclipse.scada.ae.server.injector.EventInjectorQueue;

public class JsonServlet
extends HttpServlet {
    private static final long serialVersionUID = -2152989291571139312L;
    private final EventInjectorQueue injector;

    public JsonServlet(EventInjectorQueue injector) {
        this.injector = injector;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo() == null) {
            this.send404Error(request, response);
            return;
        }
        if (request.getPathInfo().equals("/publish") || request.getPathInfo().equals("/publish/")) {
            int len;
            BufferedReader reader = request.getReader();
            char[] buffer = new char[4096];
            StringBuilder sb = new StringBuilder();
            while ((len = reader.read(buffer, 0, buffer.length)) != -1) {
                sb.append(buffer, 0, len);
            }
            Event event = EventSerializer.deserializeEvent(sb.toString());
            this.injector.injectEvent(event, new InjectionContext.Builder().sourceModule("org.eclipse.scada.ae.server.http").build());
            response.setContentType("text/plain");
            PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
            pw.write("OK");
            pw.close();
        } else {
            this.send404Error(request, response);
        }
    }

    private void send404Error(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404);
    }
}

