/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.memory.AbstractAttribute;
import org.eclipse.scada.da.server.common.memory.ByteOrder;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.eclipse.scada.da.server.common.memory.accessor.Accessor;

public abstract class AbstractAccessorAttribute<T>
extends AbstractAttribute {
    private final int index;
    private T lastValue;
    private Variant lastTimestamp;
    private final boolean enableTimestamp;
    private final ByteOrder order;
    private final Accessor<T> accessor;

    public AbstractAccessorAttribute(String name, int index, ByteOrder order, boolean enableTimestamp, Accessor<T> accessor) {
        super(name);
        this.index = index;
        this.enableTimestamp = enableTimestamp;
        this.order = order;
        this.accessor = accessor;
    }

    protected abstract T getValue(Variant var1);

    @Override
    public void handleData(IoBuffer data, Map<String, Variant> attributes, Variant timestamp) {
        Object s = this.order != null ? this.order.get(data, this.index, this.accessor) : this.accessor.get(data, this.index);
        attributes.put(this.name, Variant.valueOf(s));
        if (!s.equals(this.lastValue)) {
            this.lastValue = s;
            this.lastTimestamp = timestamp;
        }
        if (this.enableTimestamp) {
            attributes.put(String.valueOf(this.name) + ".timestamp", this.lastTimestamp);
        }
    }

    @Override
    public void handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            throw new IllegalStateException("Device is not connected");
        }
        T cvtValue = this.getValue(value);
        if (cvtValue != null) {
            IoBuffer data = IoBuffer.allocate((int)this.accessor.getBufferSize(cvtValue));
            if (this.order != null) {
                this.order.put(data, this.accessor, cvtValue);
            } else {
                this.accessor.put(data, cvtValue);
            }
            block.writeData(this.toAddress(this.index), data.array());
        }
    }

    @Override
    public void handleError(Map<String, Variant> attributes) {
        this.lastValue = null;
        this.lastTimestamp = null;
    }
}

