/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.ByteOrder;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.eclipse.scada.da.server.common.memory.ScalarVariable;
import org.eclipse.scada.da.server.common.memory.accessor.Accessor;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;

public abstract class AbstractAccessorVariable<T>
extends ScalarVariable {
    private final ByteOrder order;
    private final Accessor<T> accessor;

    public AbstractAccessorVariable(String name, int index, ByteOrder order, Executor executor, ManageableObjectPool<DataItem> itemPool, Accessor<T> accessor, Attribute ... attributes) {
        super(name, index, executor, itemPool, attributes);
        this.order = order;
        this.accessor = accessor;
    }

    protected abstract T getValue(Variant var1);

    @Override
    protected NotifyFuture<WriteResult> handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            return new InstantErrorFuture((Throwable)new IllegalStateException("Device is not connected"));
        }
        T cvtValue = this.getValue(value);
        if (cvtValue != null) {
            IoBuffer data = IoBuffer.allocate((int)this.accessor.getBufferSize(cvtValue));
            if (this.order != null) {
                this.order.put(data, this.accessor, cvtValue);
            } else {
                this.accessor.put(data, cvtValue);
            }
            block.writeData(this.toAddress(this.index), data.array());
            return new InstantFuture((Object)WriteResult.OK);
        }
        return new InstantErrorFuture((Throwable)new IllegalArgumentException(String.format("Can only write doubles: %s is not a double", value)));
    }

    @Override
    protected Variant extractValue(IoBuffer data, Map<String, Variant> attributes) {
        Object value = this.order != null ? this.order.get(data, this.toAddress(this.index), this.accessor) : this.accessor.get(data, this.toAddress(this.index));
        return Variant.valueOf(value);
    }
}

