/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttribute
implements Attribute {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAttribute.class);
    protected final String name;
    protected int offset;
    protected MemoryRequestBlock block;
    private boolean stopped;

    public AbstractAttribute(String name) {
        this.name = name;
        this.stopped = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void start(MemoryRequestBlock block, int offset) {
        logger.debug("Starting attribute: {}", (Object)this.name);
        this.stopped = false;
        assert (block != null);
        this.block = block;
        this.offset = offset;
    }

    @Override
    public void stop() {
        logger.debug("Stopping attribute: {}", (Object)this.name);
        this.stopped = true;
        this.block = null;
    }

    protected int toAddress(int localAddress) {
        if (this.stopped || this.block == null) {
            logger.error("isStopped");
        }
        return localAddress + this.offset - this.block.getStartAddress();
    }
}

