/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.event;

import java.beans.PropertyEditor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.utils.filter.Assertion;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterAssertion;
import org.eclipse.scada.utils.filter.FilterExpression;
import org.eclipse.scada.utils.propertyeditors.DateEditor;
import org.eclipse.scada.utils.propertyeditors.IntegerEditor;
import org.eclipse.scada.utils.propertyeditors.PropertyEditorRegistry;
import org.eclipse.scada.utils.propertyeditors.StringEditor;
import org.eclipse.scada.utils.propertyeditors.UUIDEditor;

public class FilterUtils {
    public static PropertyEditorRegistry propertyEditorRegistry = new PropertyEditorRegistry();

    static {
        propertyEditorRegistry.registerCustomEditor(String.class, (PropertyEditor)new StringEditor());
        propertyEditorRegistry.registerCustomEditor(Integer.class, (PropertyEditor)new IntegerEditor());
        propertyEditorRegistry.registerCustomEditor(Date.class, (PropertyEditor)new DateEditor());
        propertyEditorRegistry.registerCustomEditor(java.sql.Date.class, (PropertyEditor)new DateEditor());
        propertyEditorRegistry.registerCustomEditor(Calendar.class, (PropertyEditor)new DateEditor());
        propertyEditorRegistry.registerCustomEditor(UUID.class, (PropertyEditor)new UUIDEditor());
        propertyEditorRegistry.registerCustomEditor(Variant.class, (PropertyEditor)new VariantEditor());
    }

    public static void toVariant(Filter filter) {
        if (filter.isAssertion()) {
            FilterAssertion filterAssertion = (FilterAssertion)filter;
            if (filterAssertion.getValue() instanceof List && filterAssertion.getAssertion() == Assertion.SUBSTRING) {
                List values = (List)filterAssertion.getValue();
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (String string : values) {
                    if (i > 0 && i < values.size()) {
                        sb.append("%");
                    }
                    sb.append(string);
                    ++i;
                }
                filterAssertion.setValue((Object)sb.toString());
            }
            if (filterAssertion.getValue() instanceof String) {
                PropertyEditor pe;
                if ("id".equals(filterAssertion.getAttribute())) {
                    pe = propertyEditorRegistry.findCustomEditor(UUID.class);
                    pe.setAsText((String)filterAssertion.getValue());
                    filterAssertion.setValue(pe.getValue());
                } else if ("sourceTimestamp".equals(filterAssertion.getAttribute()) || "entryTimestamp".equals(filterAssertion.getAttribute())) {
                    pe = propertyEditorRegistry.findCustomEditor(Date.class);
                    pe.setAsText((String)filterAssertion.getValue());
                    filterAssertion.setValue(pe.getValue());
                } else {
                    VariantEditor ve = new VariantEditor();
                    ve.setAsText((String)filterAssertion.getValue());
                    filterAssertion.setValue(ve.getValue());
                }
            }
        } else if (filter.isExpression()) {
            FilterExpression filterExpression = (FilterExpression)filter;
            for (Filter child : filterExpression.getFilterSet()) {
                FilterUtils.toVariant(child);
            }
        }
    }
}

