/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.command;

import java.util.Collection;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.exec.Hive;
import org.eclipse.scada.da.server.exec.command.AbstractContinuousCommand;
import org.eclipse.scada.da.server.exec.command.ExecutionResult;
import org.eclipse.scada.da.server.exec.command.ProcessConfiguration;
import org.eclipse.scada.da.server.exec.extractor.Extractor;
import org.eclipse.scada.da.server.exec.splitter.Splitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractorContinuousCommand
extends AbstractContinuousCommand {
    private static final Logger logger = LoggerFactory.getLogger(ExtractorContinuousCommand.class);
    private int currentLineCount;
    private final Collection<Extractor> extrators;
    private final int ignoreStartLines;
    private DataItemInputChained lastInput;

    public ExtractorContinuousCommand(String id, ProcessConfiguration processConfiguration, int restartDelay, int maxInputBuffer, int ignoreStartLines, Splitter splitter, Collection<Extractor> extractors) {
        super(id, processConfiguration, restartDelay, maxInputBuffer, splitter);
        this.extrators = extractors;
        this.ignoreStartLines = ignoreStartLines;
    }

    @Override
    public void start(Hive hive, FolderCommon parentFolder) {
        super.start(hive, parentFolder);
        this.lastInput = this.itemFactory.createInput("lastInput", null);
        for (Extractor extractor : this.extrators) {
            extractor.register(hive, this.itemFactory);
        }
    }

    @Override
    public void stop() {
        for (Extractor extractor : this.extrators) {
            extractor.unregister();
        }
        super.stop();
    }

    @Override
    protected void processFailed(Throwable e) {
        super.processFailed(e);
        ExecutionResult result = new ExecutionResult();
        result.setExecutionError(new RuntimeException("Process failed", e));
        for (Extractor extractor : this.extrators) {
            extractor.process(result);
        }
    }

    @Override
    protected void handleStdLine(String line) {
        logger.debug("Got line: " + line);
        this.lastInput.updateData(Variant.valueOf((Object)line), null, null);
        ++this.currentLineCount;
        if (this.currentLineCount > this.ignoreStartLines) {
            ExecutionResult result = new ExecutionResult();
            result.setOutput(line);
            for (Extractor extractor : this.extrators) {
                extractor.process(result);
            }
        }
    }

    @Override
    protected void processStarted(Process process) {
        this.currentLineCount = 0;
        super.processStarted(process);
    }
}

