/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.splitter;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.da.server.exec.splitter.SplitResult;
import org.eclipse.scada.da.server.exec.splitter.Splitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExMatchSplitter
implements Splitter {
    private static final Logger logger = LoggerFactory.getLogger(RegExMatchSplitter.class);
    private final Pattern pattern;

    public RegExMatchSplitter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public SplitResult split(String inputBuffer) {
        SplitResult result = new SplitResult();
        ArrayList<String> list = new ArrayList<String>();
        boolean hadMatch = false;
        Matcher m = this.pattern.matcher(inputBuffer);
        logger.debug("Matcher: " + m);
        while (m.find()) {
            hadMatch = true;
            list.add(m.group());
        }
        if (hadMatch) {
            result.setLines(list.toArray(new String[0]));
            result.setRemainingBuffer(inputBuffer.substring(m.end()));
            return result;
        }
        return null;
    }
}

