/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.mina;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.future.WriteFuture;
import org.eclipse.scada.net.base.MessageListener;
import org.eclipse.scada.net.base.MessageStateListener;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.mina.MessageSender;
import org.eclipse.scada.net.mina.PrepareSendHandler;
import org.eclipse.scada.net.utils.MessageCreator;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.stats.StatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messenger
implements MessageListener {
    private static Object STATS_RECEIVED_MSGS = new Object();
    private static Object STATS_SENT_MSGS = new Object();
    private static final Logger logger = LoggerFactory.getLogger(Messenger.class);
    private ScheduledFuture<?> timeoutJob;
    private final Map<Long, MessageTag> tagList = new HashMap<Long, MessageTag>();
    private MessageSender connection;
    private ScheduledExecutorService timer;
    private final long sessionTimeout;
    private final long timeoutJobPeriod;
    private final StatisticsImpl statistics;
    private final Map<Integer, MessageListener> listeners = new HashMap<Integer, MessageListener>();
    private volatile long lastMessge;

    public Messenger(long timeout, StatisticsImpl statistics) {
        this.sessionTimeout = timeout;
        this.timeoutJobPeriod = 1000L;
        this.statistics = statistics;
        statistics.setLabel(STATS_RECEIVED_MSGS, "Received messages");
        statistics.setLabel(STATS_SENT_MSGS, "Sent messages");
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    protected void finalize() throws Throwable {
        logger.debug("Finalized");
        if (this.timer != null) {
            this.timer.shutdown();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(MessageSender connection) {
        this.disconnected();
        Collection<MessageTag> tags = null;
        Messenger messenger = this;
        synchronized (messenger) {
            if (connection != null) {
                logger.info("Messenger connected");
                this.connection = connection;
                tags = this.cleanTagList();
                this.timer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("MessengerTimer/" + connection, true));
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Messenger.this.processTimeOuts();
                    }

                    protected void finalize() throws Throwable {
                        logger.debug("Finalized timeout job");
                        super.finalize();
                    }
                };
                this.timeoutJob = this.timer.scheduleWithFixedDelay(runnable, this.sessionTimeout, this.timeoutJobPeriod, TimeUnit.MILLISECONDS);
            }
        }
        Messenger.fireTimeouts(tags);
    }

    protected synchronized Collection<MessageTag> performDisconnect() {
        if (this.connection != null) {
            this.connection = null;
            logger.info("Disconnected");
            Collection<MessageTag> tags = this.cleanTagList();
            if (this.timeoutJob != null) {
                this.timeoutJob.cancel(false);
                this.timeoutJob = null;
            }
            if (this.timer != null) {
                this.timer.shutdown();
                this.timer = null;
            }
            return tags;
        }
        return null;
    }

    public void disconnected() {
        Collection<MessageTag> tags = this.performDisconnect();
        Messenger.fireTimeouts(tags);
    }

    private static void fireTimeouts(Collection<MessageTag> tags) {
        if (tags != null) {
            for (MessageTag tag : tags) {
                tag.getListener().messageTimedOut();
            }
        }
    }

    public void setHandler(int commandCode, MessageListener handler) {
        this.listeners.put(commandCode, handler);
    }

    public void unsetHandler(int commandCode) {
        this.listeners.remove(commandCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<MessageTag> cleanTagList() {
        LinkedList<MessageTag> tags = new LinkedList<MessageTag>();
        Map<Long, MessageTag> map = this.tagList;
        synchronized (map) {
            for (Map.Entry<Long, MessageTag> tag : this.tagList.entrySet()) {
                try {
                    if (tag.getValue().isCanceled()) continue;
                    tag.getValue().cancel();
                    tags.add(tag.getValue());
                }
                catch (Throwable e) {
                    logger.warn("Failed to handle message timeout", e);
                }
            }
            this.tagList.clear();
        }
        return tags;
    }

    @Override
    public void messageReceived(Message message) {
        this.statistics.changeCurrentValue(STATS_RECEIVED_MSGS, 1.0);
        this.lastMessge = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            if (message.getReplySequence() == 0L) {
                logger.debug(String.format("Received message: 0x%1$08X Seq: %2$d", message.getCommandCode(), message.getSequence()));
            } else {
                logger.debug(String.format("Received message: 0x%1$08X Seq: %2$d in reply to: %3$d", message.getCommandCode(), message.getSequence(), message.getReplySequence()));
            }
        }
        if (this.handleTagMessage(message)) {
            return;
        }
        if (this.handleDefaultMessage(message)) {
            return;
        }
        if (this.handleHandlerMessage(message)) {
            return;
        }
        this.handleUnknownMessage(message);
    }

    protected void handleUnknownMessage(Message message) {
        this.sendMessage(MessageCreator.createUnknownMessage(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleTagMessage(Message message) {
        Long seq = message.getReplySequence();
        MessageTag tag = null;
        Map<Long, MessageTag> map = this.tagList;
        synchronized (map) {
            if (this.tagList.containsKey(seq)) {
                tag = this.tagList.get(seq);
                if (tag.isTimedOut()) {
                    logger.info("Found tag for message {} but it is timed out", (Object)seq);
                    return true;
                }
                this.tagList.remove(seq);
            }
        }
        try {
            if (tag == null) return tag != null;
            logger.debug("Processing message listener for message {}", (Object)seq);
            tag.getListener().messageReply(message);
            return tag != null;
        }
        catch (Throwable e) {
            logger.warn("Custom message failed", e);
        }
        return tag != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimeOuts() {
        LinkedList<MessageTag> removeBag = new LinkedList<MessageTag>();
        this.checkSessionTimeout();
        Map<Long, MessageTag> map = this.tagList;
        synchronized (map) {
            Iterator<Map.Entry<Long, MessageTag>> i = this.tagList.entrySet().iterator();
            while (i.hasNext()) {
                MessageTag tag = i.next().getValue();
                if (!tag.isTimedOut()) continue;
                removeBag.add(tag);
                i.remove();
            }
        }
        for (MessageTag tag : removeBag) {
            try {
                tag.getListener().messageTimedOut();
            }
            catch (Throwable e) {
                logger.info("Failed to handle messageTimedOut", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSessionTimeout() {
        long now = System.currentTimeMillis();
        long timeDiff = now - this.lastMessge;
        if (this.connection == null) {
            logger.warn("Called without a connection");
        }
        if (timeDiff > this.sessionTimeout) {
            Collection<MessageTag> tags;
            Messenger messenger = this;
            synchronized (messenger) {
                if (this.connection == null) {
                    return;
                }
                logger.warn("Closing connection due to receive timeout: {} (timeout: {})", (Object)timeDiff, (Object)this.sessionTimeout);
                this.connection.close();
                tags = this.performDisconnect();
            }
            Messenger.fireTimeouts(tags);
        }
    }

    public WriteFuture sendMessage(Message message) {
        return this.sendMessage(message, null);
    }

    public WriteFuture sendMessage(Message message, MessageStateListener messageListener) {
        return this.sendMessage(message, messageListener, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerMessageTag(long sequence, MessageTag messageTag) {
        if (messageTag.getListener() == null) {
            return;
        }
        Map<Long, MessageTag> map = this.tagList;
        synchronized (map) {
            this.tagList.put(sequence, messageTag);
        }
    }

    public WriteFuture sendMessage(Message message, MessageStateListener listener, long timeout) {
        WriteFuture future;
        logger.debug("Sending message: {}", (Object)message.getCommandCode());
        this.statistics.changeCurrentValue(STATS_SENT_MSGS, 1.0);
        MessageSender connection = this.connection;
        if (connection != null) {
            final MessageTag tag = new MessageTag();
            tag.setListener(listener);
            tag.setTimestamp(System.currentTimeMillis());
            tag.setTimeout(timeout < 0L ? 0L : timeout);
            future = connection.sendMessage(message, new PrepareSendHandler(){

                @Override
                public void prepareSend(Message message) {
                    Messenger.this.registerMessageTag(message.getSequence(), tag);
                }
            });
        } else {
            future = null;
        }
        if (future == null && listener != null) {
            listener.messageTimedOut();
        }
        return future;
    }

    protected boolean handleDefaultMessage(Message message) {
        switch (message.getCommandCode()) {
            case 2: {
                String errorInfo = "";
                if (message.getValues().containsKey("error-info")) {
                    errorInfo = message.getValues().get("error-info").toString();
                }
                logger.warn("Failed message: {} / {} / Message: {}", new Object[]{message.getSequence(), message.getReplySequence(), errorInfo});
                return true;
            }
            case 1: {
                logger.warn("Reply to unknown message command code from peer: {} / {}", (Object)message.getSequence(), (Object)message.getReplySequence());
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected boolean handleHandlerMessage(Message message) {
        MessageListener listener = this.listeners.get(message.getCommandCode());
        if (listener != null) {
            try {
                logger.debug("Let handler {} serve message {}", (Object)listener, (Object)message.getCommandCode());
                listener.messageReceived(message);
            }
            catch (Throwable e) {
                logger.warn("Message processing failed", e);
                this.connection.sendMessage(MessageCreator.createFailedMessage(message, e), null);
            }
            return true;
        }
        logger.warn("Received message which cannot be processed by handler! cc = {}", (Object)message.getCommandCode());
        return false;
    }

    private static class MessageTag {
        private MessageStateListener listener;
        private long timestamp = 0L;
        private long timeout = 0L;
        private boolean canceled = false;

        private MessageTag() {
        }

        public MessageStateListener getListener() {
            return this.listener;
        }

        public void setListener(MessageStateListener listener) {
            this.listener = listener;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public synchronized boolean isTimedOut() {
            if (this.timeout <= 0L) {
                return this.canceled;
            }
            if (this.canceled) {
                return true;
            }
            return System.currentTimeMillis() - this.timestamp >= this.timeout;
        }

        public synchronized void cancel() {
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }
}

