/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.info.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.monitor.MonitorListener;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.base.DataInputOutputSource;
import org.eclipse.scada.da.datasource.base.DataInputSource;
import org.eclipse.scada.da.datasource.base.WriteHandler;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.AllObjectPoolServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoService {
    private static final String ALERT_ACTIVE_ITEM = "ALERT_ACTIVE";
    private static final String ALERT_DISABLED_ITEM = "ALERT_DISABLED";
    private static final Logger logger = LoggerFactory.getLogger(InfoService.class);
    private final Executor executor;
    private final ObjectPoolImpl<DataSource> dataSourcePool;
    private final Map<String, DataInputSource> items = new HashMap<String, DataInputSource>();
    private final DataInputOutputSource alertActiveItem;
    private final DataInputOutputSource alertDisabledItem;
    private String prefix;
    private final Map<String, MonitorStatusInformation> cachedMonitors = new HashMap<String, MonitorStatusInformation>();
    private final Map<MonitorStatus, AtomicInteger> aggregatedMonitors = new HashMap<MonitorStatus, AtomicInteger>();
    private volatile boolean alertDisabled = false;
    private final AllObjectPoolServiceTracker<MonitorService> tracker;

    public InfoService(BundleContext context, final Executor executor, ObjectPoolTracker<MonitorService> monitorPoolTracker, ObjectPoolImpl<DataSource> dataSourcePool) {
        this.executor = executor;
        this.dataSourcePool = dataSourcePool;
        this.clearAggregatedMonitors();
        MonitorStatus[] monitorStatusArray = MonitorStatus.values();
        int n = monitorStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorStatus monitorStatus = monitorStatusArray[n2];
            this.items.put(monitorStatus.name(), new DataInputSource(executor));
            ++n2;
        }
        this.alertActiveItem = new DataInputOutputSource(executor);
        this.alertActiveItem.setWriteHandler(new WriteHandler(){

            public void handleWrite(UserInformation userInformation, Variant value) throws Exception {
                InfoService.this.setValue((DataInputSource)InfoService.this.alertActiveItem, value.asBoolean(Boolean.valueOf(false)));
            }
        });
        this.alertDisabledItem = new DataInputOutputSource(executor);
        this.alertDisabledItem.setWriteHandler(new WriteHandler(){

            public void handleWrite(UserInformation userInformation, Variant value) throws Exception {
                InfoService.this.setAlertDisabled(value.asBoolean(Boolean.valueOf(false)));
            }
        });
        final MonitorListener ml = new MonitorListener(){

            public void statusChanged(final MonitorStatusInformation status) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        InfoService.this.handleStatusChanged(status);
                    }
                });
            }
        };
        ObjectPoolListener<MonitorService> objectPoolListener = new ObjectPoolListener<MonitorService>(){

            public void serviceAdded(MonitorService service, Dictionary<?, ?> properties) {
                service.addStatusListener(ml);
            }

            public void serviceRemoved(MonitorService service, Dictionary<?, ?> properties) {
                service.removeStatusListener(ml);
                InfoService.this.triggerRemoveMonitor(service);
            }

            public void serviceModified(MonitorService service, Dictionary<?, ?> properties) {
                service.removeStatusListener(ml);
                service.addStatusListener(ml);
            }
        };
        this.tracker = new AllObjectPoolServiceTracker(monitorPoolTracker, (ObjectPoolListener)objectPoolListener);
        logger.debug("InfoService created");
        this.notifyChanges();
        this.setValue((DataInputSource)this.alertActiveItem, false);
        this.setValue((DataInputSource)this.alertDisabledItem, this.alertDisabled);
        this.tracker.open();
    }

    protected void triggerRemoveMonitor(final MonitorService service) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                InfoService.this.handleRemoveMonitor(service);
            }
        });
    }

    public void update(final Map<String, String> parameters) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                InfoService.this.handleUpdate(parameters);
            }
        });
    }

    public void dispose() {
        this.unregisterItems(this.prefix);
        this.tracker.close();
    }

    private void handleUpdate(Map<String, String> parameters) {
        logger.debug("parameter change requested");
        this.unregisterItems(this.prefix);
        this.prefix = this.defaultParameter(parameters, "prefix", "ae.server.info");
        this.registerItems(this.prefix);
        logger.info("parameters changed");
    }

    private void registerItems(String prefix) {
        for (Map.Entry<String, DataInputSource> entry : this.items.entrySet()) {
            String id = String.valueOf(prefix) + "." + entry.getKey();
            logger.info("register item with id {}", (Object)id);
            this.dataSourcePool.addService(id, (Object)((DataSource)entry.getValue()), (Dictionary)new Properties());
        }
        this.dataSourcePool.addService(String.valueOf(prefix) + "." + ALERT_ACTIVE_ITEM, (Object)this.alertActiveItem, (Dictionary)new Properties());
        this.dataSourcePool.addService(String.valueOf(prefix) + "." + ALERT_DISABLED_ITEM, (Object)this.alertDisabledItem, (Dictionary)new Properties());
    }

    private void unregisterItems(String prefix) {
        for (Map.Entry<String, DataInputSource> entry : this.items.entrySet()) {
            String id = String.valueOf(prefix) + "." + entry.getKey();
            this.dataSourcePool.removeService(id, (Object)((DataSource)entry.getValue()));
            logger.info("unregister item with id {}", (Object)id);
        }
        this.dataSourcePool.removeService(String.valueOf(prefix) + "." + ALERT_ACTIVE_ITEM, (Object)this.alertActiveItem);
        this.dataSourcePool.removeService(String.valueOf(prefix) + "." + ALERT_DISABLED_ITEM, (Object)this.alertDisabledItem);
    }

    private void handleStatusChanged(MonitorStatusInformation msi) {
        if (msi == null) {
            throw new IllegalArgumentException("'monitorInformation' must not be null");
        }
        Boolean active = null;
        MonitorStatusInformation oldMsi = this.cachedMonitors.put(msi.getId(), msi);
        if (oldMsi != null) {
            this.aggregatedMonitors.get(oldMsi.getStatus()).decrementAndGet();
            if (this.requireAkn(oldMsi.getStatus())) {
                active = false;
            }
        }
        this.aggregatedMonitors.get(msi.getStatus()).incrementAndGet();
        if (this.requireAkn(msi.getStatus())) {
            active = true;
        }
        if (active != null) {
            if (active.booleanValue()) {
                this.alert();
            } else {
                this.silenceAlert();
            }
        }
        this.notifyChanges();
    }

    private boolean requireAkn(MonitorStatus status) {
        return status == MonitorStatus.NOT_OK_NOT_AKN || status == MonitorStatus.NOT_AKN;
    }

    protected void handleRemoveMonitor(MonitorService service) {
        logger.debug("Removing monitor service: {}", (Object)service.getId());
        MonitorStatusInformation msi = this.cachedMonitors.remove(service.getId());
        if (msi == null) {
            return;
        }
        logger.debug("Monitor service got removed, cleaning up...");
        this.aggregatedMonitors.get(msi.getStatus()).decrementAndGet();
        logger.debug("Monitor state was: {}", (Object)msi);
        if (this.requireAkn(msi.getStatus())) {
            boolean active;
            boolean bl = active = this.aggregatedMonitors.get(MonitorStatus.NOT_AKN).get() <= 0 && this.aggregatedMonitors.get(MonitorStatus.NOT_OK_NOT_AKN).get() <= 0;
            if (!active) {
                logger.debug("We can silence the alarm");
                this.silenceAlert();
            }
        }
        this.notifyChanges();
    }

    private void alert() {
        logger.info("alert enabled");
        if (!this.alertDisabled) {
            this.setValue((DataInputSource)this.alertActiveItem, true);
        }
    }

    private void silenceAlert() {
        logger.info("alert disabled");
        this.setValue((DataInputSource)this.alertActiveItem, false);
    }

    private void setAlertDisabled(boolean disabled) {
        this.alertDisabled = disabled;
        this.setValue((DataInputSource)this.alertDisabledItem, this.alertDisabled);
        if (disabled) {
            this.silenceAlert();
        }
    }

    private void clearAggregatedMonitors() {
        this.aggregatedMonitors.clear();
        MonitorStatus[] monitorStatusArray = MonitorStatus.values();
        int n = monitorStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorStatus status = monitorStatusArray[n2];
            this.aggregatedMonitors.put(status, new AtomicInteger(0));
            ++n2;
        }
    }

    private void notifyChanges() {
        MonitorStatus[] monitorStatusArray = MonitorStatus.values();
        int n = monitorStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorStatus monitorStatus = monitorStatusArray[n2];
            this.setValue(this.items.get(monitorStatus.name()), this.aggregatedMonitors.get(monitorStatus));
            ++n2;
        }
    }

    private void setValue(DataInputSource item, Object value) {
        DataItemValue.Builder div = new DataItemValue.Builder();
        div.setValue(Variant.valueOf((Object)value));
        item.setValue(div.build());
    }

    private String defaultParameter(Map<String, String> parameters, String key, String defaultValue) {
        String value = parameters.get(key);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return value;
    }
}

