/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.injector.internal;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.handler.EventHandler;
import org.eclipse.scada.ae.server.handler.EventHandlerFactory;
import org.eclipse.scada.ae.server.handler.InjectionContext;
import org.eclipse.scada.ae.server.injector.EventInjector;
import org.eclipse.scada.ae.server.injector.internal.EventHandlerFactoryTracker;
import org.eclipse.scada.ae.server.injector.monitor.EventMonitorEvaluator;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.str.Tables;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventInjectorImpl
implements EventInjector,
ConfigurationFactory {
    private static final String DEFAULT_HANDLER_FACTORY = System.getProperty("org.eclipse.scada.ae.server.injector.defaultHandlerFactory", "defaultStorage");
    private static final String DEFAULT_ID = "default";
    private static final Logger logger = LoggerFactory.getLogger(EventInjectorImpl.class);
    private final EventMonitorEvaluator evaluator;
    private final Lock readLock;
    private final Lock writeLock;
    private final SortedSet<Entry> entries = new TreeSet<Entry>();
    private final Map<String, Entry> entryMap = new HashMap<String, Entry>();
    private final Map<String, EventHandlerFactory> factoryMap = new HashMap<String, EventHandlerFactory>();
    private static final boolean USE_DEFAULT = !Boolean.getBoolean("org.eclipse.scada.ae.server.injector.disableDefault");
    private final EventHandlerFactoryTracker.Listener factoryListener = new EventHandlerFactoryTracker.Listener(){

        @Override
        public void factoryRemoved(String factoryId) {
            EventInjectorImpl.this.handleFactoryRemoved(factoryId);
        }

        @Override
        public void factoryAdded(String factoryId, EventHandlerFactory factory) {
            EventInjectorImpl.this.handleFactoryAdded(factoryId, factory);
        }
    };
    private final EventHandlerFactoryTracker factoryTracker;
    private final ExportedExecutorService executor;
    private final BundleContext context;
    private ServiceRegistration<EventInjector> handle;
    private boolean hasDefault;

    public EventInjectorImpl(BundleContext context, EventMonitorEvaluator evaluator) {
        this.context = context;
        ReentrantReadWriteLock rw = new ReentrantReadWriteLock();
        this.readLock = rw.readLock();
        this.writeLock = rw.writeLock();
        this.evaluator = evaluator;
        this.executor = new ExportedExecutorService("org.eclipse.scada.ae.server.injector", 1, 1, 1L, TimeUnit.MINUTES);
        this.factoryTracker = new EventHandlerFactoryTracker(context, this.factoryListener);
        this.addDefault();
    }

    private void addDefault() {
        if (!USE_DEFAULT) {
            return;
        }
        if (this.entries.isEmpty() && !this.hasDefault) {
            logger.info("Adding default entry");
            Entry defaultEntry = new Entry(DEFAULT_ID, 0, DEFAULT_HANDLER_FACTORY, Collections.emptyMap());
            this.internalAddEntry(defaultEntry);
            this.hasDefault = true;
        }
    }

    private void removeDefault() {
        if (!USE_DEFAULT) {
            return;
        }
        if (!this.entries.isEmpty() && this.hasDefault) {
            logger.debug("Removing default entry");
            this.internalDelete(DEFAULT_ID);
            this.hasDefault = false;
        }
    }

    public void dispose() {
        this.writeLock.lock();
        try {
            for (Entry entry : this.entries) {
                entry.dispose();
            }
            this.entries.clear();
            this.entryMap.clear();
            if (this.factoryTracker != null) {
                this.factoryTracker.dispose();
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void injectEvent(Event event, InjectionContext context) {
        this.readLock.lock();
        try {
            Event evalEvent = this.evaluator.evaluate(event);
            for (Entry entry : this.entries) {
                evalEvent = entry.handler.handleEvent(evalEvent, context);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void handleFactoryAdded(final String factoryId, final EventHandlerFactory factory) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventInjectorImpl.this.processFactoryAdded(factoryId, factory);
            }
        });
    }

    protected void handleFactoryRemoved(final String factoryId) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventInjectorImpl.this.processFactoryRemoved(factoryId);
            }
        });
    }

    protected void processFactoryAdded(String factoryId, EventHandlerFactory factory) {
        this.writeLock.lock();
        try {
            this.factoryMap.put(factoryId, factory);
            for (Entry entry : this.entries) {
                if (!entry.getFactoryId().equals(factoryId)) continue;
                entry.setFactory(factory);
            }
            this.checkValid();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void processFactoryRemoved(String factoryId) {
        logger.debug("Removing factory - factoryId: {}", (Object)factoryId);
        this.writeLock.lock();
        try {
            this.factoryMap.remove(factoryId);
            for (Entry entry : this.entries) {
                if (!entry.getFactoryId().equals(factoryId)) continue;
                entry.setFactory(null);
            }
            this.checkValid();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void state() {
        this.readLock.lock();
        try {
            int count = 0;
            for (Entry entry : this.entries) {
                if (entry.isRealized()) continue;
                ++count;
            }
            if (count == 0) {
                System.out.println("All entries are realized");
            } else {
                System.out.format("%s of %s entries are NOT realized%n", count, this.entries.size());
            }
            if (this.hasDefault) {
                System.out.println("Default entry is in place");
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void rules() {
        this.readLock.lock();
        try {
            List<String> header = Arrays.asList("Prio", "ID", "Realized", "Error");
            LinkedList data = new LinkedList();
            for (Entry entry : this.entries) {
                LinkedList<String> row = new LinkedList<String>();
                row.add("" + entry.priority);
                row.add(entry.id);
                row.add(entry.isRealized() ? "X" : "");
                if (entry.error != null) {
                    row.add(ExceptionHelper.getMessage((Throwable)entry.error));
                } else {
                    row.add("");
                }
                data.add(row);
            }
            Tables.showTable((PrintStream)System.out, header, data, (int)1);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void update(UserInformation userInformation, String configurationId, Map<String, String> properties) throws Exception {
        this.writeLock.lock();
        try {
            ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
            Entry entry = new Entry(configurationId, cfg.getInteger("priority", 0), cfg.getStringNonEmptyChecked("factory.id", null), cfg.getPrefixed("properties."));
            this.removeDefault();
            this.internalAddEntry(entry);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void internalAddEntry(Entry entry) {
        EventHandlerFactory factory;
        Entry oldEntry = this.entryMap.put(entry.id, entry);
        if (oldEntry != null) {
            logger.debug("Remove old entry - entry: {}", (Object)oldEntry);
            this.entries.remove(oldEntry);
            oldEntry.dispose();
        }
        if ((factory = this.factoryMap.get(entry.getFactoryId())) != null) {
            logger.debug("Setting factory - factory: {}", (Object)factory);
            entry.setFactory(factory);
        }
        this.entries.add(entry);
        this.addDefault();
        this.checkValid();
    }

    public void delete(UserInformation userInformation, String configurationId) throws Exception {
        this.writeLock.lock();
        try {
            this.internalDelete(configurationId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void internalDelete(String id) {
        Entry entry = this.entryMap.remove(id);
        if (entry == null) {
            return;
        }
        this.entries.remove(entry);
        entry.dispose();
        this.addDefault();
        this.checkValid();
    }

    private void checkValid() {
        this.setActive(this.isValid());
    }

    private void setActive(boolean valid) {
        logger.debug("set active - valid: {}, handle: {}", (Object)valid, this.handle);
        if (valid && this.handle == null) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.description", "Event injector service");
            ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
            this.handle = this.context.registerService(EventInjector.class, (Object)this, properties);
        } else if (!valid && this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
    }

    private boolean isValid() {
        for (Entry entry : this.entries) {
            if (entry.isRealized()) continue;
            return false;
        }
        return true;
    }

    private static final class Entry
    implements Comparable<Entry> {
        private final String id;
        private final int priority;
        private final String factoryId;
        private final Map<String, String> properties;
        private EventHandler handler;
        private Exception error;

        public Entry(String id, int priority, String factoryId, Map<String, String> properties) {
            this.id = id;
            this.factoryId = factoryId;
            this.priority = priority;
            this.properties = properties;
        }

        public void dispose() {
            this.disposeHandler();
        }

        public void setFactory(EventHandlerFactory factory) {
            this.disposeHandler();
            if (factory != null) {
                try {
                    this.handler = factory.createHandler(this.properties);
                }
                catch (Exception e) {
                    this.error = e;
                }
            }
        }

        private void disposeHandler() {
            if (this.handler != null) {
                this.handler.dispose();
                this.handler = null;
            }
        }

        public boolean isRealized() {
            return this.handler != null;
        }

        public String getFactoryId() {
            return this.factoryId;
        }

        @Override
        public int compareTo(Entry o) {
            int result = Integer.compare(this.priority, o.priority);
            if (result != 0) {
                return result;
            }
            return this.id.compareTo(o.id);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + this.priority;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return this.priority == other.priority;
        }
    }
}

