/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.jdbc;

import com.google.common.collect.Interner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.jdbc.BaseStorageDao;
import org.eclipse.scada.ae.server.storage.jdbc.NotSupportedException;
import org.eclipse.scada.ae.server.storage.jdbc.SqlCondition;
import org.eclipse.scada.ae.server.storage.jdbc.SqlConverter;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.interner.InternerHelper;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.eclipse.scada.utils.str.StringHelper;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcStorageDao
extends BaseStorageDao {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJdbcStorageDao.class);
    private final String cleanupArchiveSql = "DELETE FROM %sES_AE_EVENTS WHERE ENTRY_TIMESTAMP < ?";
    private final String insertEventSql = "INSERT INTO %sES_AE_EVENTS (ID, INSTANCE_ID, SOURCE_TIMESTAMP, ENTRY_TIMESTAMP, MONITOR_TYPE, EVENT_TYPE, VALUE_TYPE, VALUE_STRING, VALUE_INTEGER, VALUE_DOUBLE, MESSAGE, MESSAGE_CODE, PRIORITY, SOURCE, ACTOR_NAME, ACTOR_TYPE, SEVERITY) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private final String insertAttributesSql = "INSERT INTO %sES_AE_EVENTS_ATTR (ID, KEY, VALUE_TYPE, VALUE_STRING, VALUE_INTEGER, VALUE_DOUBLE) VALUES (?, ?, ?, ?, ?, ?)";
    private final String deleteAttributesSql = "DELETE FROM %sES_AE_EVENTS_ATTR WHERE ID = ? AND KEY = ?";
    private final String selectEventSql = "SELECT E.ID, E.INSTANCE_ID, E.SOURCE_TIMESTAMP, E.ENTRY_TIMESTAMP, E.MONITOR_TYPE, E.EVENT_TYPE, E.VALUE_TYPE, E.VALUE_STRING, E.VALUE_INTEGER, E.VALUE_DOUBLE, E.MESSAGE, E.MESSAGE_CODE, E.PRIORITY, E.SOURCE, E.ACTOR_NAME, E.ACTOR_TYPE, E.SEVERITY, A.KEY, A.VALUE_TYPE, A.VALUE_STRING, A.VALUE_INTEGER, A.VALUE_DOUBLE FROM %1$sES_AE_EVENTS E LEFT JOIN %1$sES_AE_EVENTS_ATTR A ON (A.ID = E.ID) ";
    private final String insertReplicationEventSql = "INSERT INTO %sES_AE_REP (ID, ENTRY_TIMESTAMP, NODE_ID, DATA) VALUES (?, ?, ?, ?)";
    private final String whereSql = " WHERE E.INSTANCE_ID = ? ";
    private final String defaultOrder = " ORDER BY E.SOURCE_TIMESTAMP DESC, E.ENTRY_TIMESTAMP DESC";
    private static final int NODE_ID_LENGTH = Integer.getInteger("org.eclipse.scada.ae.server.storage.jdbc.fields.nodeId.length", 32);
    private final Interner<String> stringInterner;
    private final ReplicationDataFormat dataFormat = this.makeDataFormat();
    private String hostName;

    public AbstractJdbcStorageDao(DataSourceFactory dataSourceFactory, Properties properties, boolean usePool, Long loginTimeout, Interner<String> stringInterner) throws SQLException {
        super(dataSourceFactory, properties, usePool, loginTimeout);
        this.stringInterner = stringInterner == null ? InternerHelper.makeNoOpInterner() : stringInterner;
    }

    private ReplicationDataFormat makeDataFormat() {
        try {
            return ReplicationDataFormat.valueOf(System.getProperty("org.eclipse.scada.ae.server.storage.jdbc.replicationDataFormat", ReplicationDataFormat.BYTES.name()));
        }
        catch (Exception exception) {
            return ReplicationDataFormat.BYTES;
        }
    }

    @Override
    public void storeEvent(final Event event) throws Exception {
        this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

            protected Void performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.setAutoCommit(false);
                AbstractJdbcStorageDao.this.performStoreEvent(event, connectionContext);
                connectionContext.commit();
                return null;
            }
        });
    }

    protected void storeReplicationEvent(Event event, Connection con) throws Exception {
        PreparedStatement stmt = con.prepareStatement(String.format("INSERT INTO %sES_AE_REP (ID, ENTRY_TIMESTAMP, NODE_ID, DATA) VALUES (?, ?, ?, ?)", this.getSchema()));
        try {
            stmt.setString(1, event.getId().toString());
            stmt.setTimestamp(2, new Timestamp(event.getEntryTimestamp().getTime()));
            stmt.setString(3, this.clip(NODE_ID_LENGTH, this.getNodeId()));
            switch (this.dataFormat) {
                case BLOB: {
                    AbstractJdbcStorageDao.setReplicationDataBlob(stmt, event);
                    break;
                }
                default: {
                    AbstractJdbcStorageDao.setReplicationDataBytes(stmt, event);
                }
            }
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }

    private String getNodeId() {
        String nodeId = System.getProperty("org.eclipse.scada.ae.server.storage.jdbc.replicationNodeId", null);
        if (nodeId != null && !nodeId.isEmpty()) {
            return nodeId;
        }
        if (nodeId != null && nodeId.isEmpty()) {
            return null;
        }
        if (this.hostName == null) {
            this.hostName = System.getenv("HOSTNAME");
            if (this.hostName != null) {
                return this.hostName;
            }
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
                return this.hostName;
            }
            catch (Exception e) {
                logger.warn("Failed to lookup hostname", (Throwable)e);
                this.hostName = "<unknown>";
                return this.hostName;
            }
        }
        return this.hostName;
    }

    private static byte[] serializeEvent(Event event) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(event);
        bos.close();
        return bos.toByteArray();
    }

    private static void setReplicationDataBytes(PreparedStatement stmt, Event event) throws IOException, SQLException {
        stmt.setBytes(4, AbstractJdbcStorageDao.serializeEvent(event));
    }

    private static void setReplicationDataBlob(PreparedStatement stmt, Event event) throws SQLException, IOException {
        Blob blob = stmt.getConnection().createBlob();
        ObjectOutputStream oos = new ObjectOutputStream(blob.setBinaryStream(1L));
        oos.writeObject(event);
        oos.close();
        stmt.setBlob(4, blob);
    }

    private void storeEventData(Event event, Connection con) throws SQLException {
        PreparedStatement stm1 = null;
        PreparedStatement stm2 = null;
        PreparedStatement stm = con.prepareStatement(String.format("INSERT INTO %sES_AE_EVENTS (ID, INSTANCE_ID, SOURCE_TIMESTAMP, ENTRY_TIMESTAMP, MONITOR_TYPE, EVENT_TYPE, VALUE_TYPE, VALUE_STRING, VALUE_INTEGER, VALUE_DOUBLE, MESSAGE, MESSAGE_CODE, PRIORITY, SOURCE, ACTOR_NAME, ACTOR_TYPE, SEVERITY) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", this.getSchema()));
        stm.setString(1, event.getId().toString());
        stm.setString(2, this.getInstance());
        stm.setTimestamp(3, new Timestamp(event.getSourceTimestamp().getTime()));
        stm.setTimestamp(4, new Timestamp(event.getEntryTimestamp().getTime()));
        stm.setString(5, this.clip(32, Variant.valueOf((Object)event.getField(Event.Fields.MONITOR_TYPE)).asString("")));
        stm.setString(6, this.clip(32, Variant.valueOf((Object)event.getField(Event.Fields.EVENT_TYPE)).asString("")));
        stm.setString(7, this.clip(32, Variant.valueOf((Object)event.getField(Event.Fields.VALUE)).getType().name()));
        stm.setString(8, this.clip(this.getMaxLength(), Variant.valueOf((Object)event.getField(Event.Fields.VALUE)).asString("")));
        Long longValue = Variant.valueOf((Object)event.getField(Event.Fields.VALUE)).asLong(null);
        if (longValue == null) {
            stm.setNull(9, -5);
        } else {
            stm.setLong(9, longValue);
        }
        Double doubleValue = Variant.valueOf((Object)event.getField(Event.Fields.VALUE)).asDouble(null);
        if (doubleValue == null) {
            stm.setNull(10, 8);
        } else {
            stm.setDouble(10, longValue.longValue());
        }
        stm.setString(11, this.clip(this.getMaxLength(), Variant.valueOf((Object)event.getField(Event.Fields.MESSAGE)).asString("")));
        stm.setString(12, this.clip(255, Variant.valueOf((Object)event.getField(Event.Fields.MESSAGE_CODE)).asString("")));
        stm.setInt(13, Variant.valueOf((Object)event.getField(Event.Fields.PRIORITY)).asInteger(Integer.valueOf(50)));
        stm.setString(14, this.clip(255, Variant.valueOf((Object)event.getField(Event.Fields.SOURCE)).asString("")));
        stm.setString(15, this.clip(128, Variant.valueOf((Object)event.getField(Event.Fields.ACTOR_NAME)).asString("")));
        stm.setString(16, this.clip(32, Variant.valueOf((Object)event.getField(Event.Fields.ACTOR_TYPE)).asString("")));
        stm.setString(17, this.clip(32, Variant.valueOf((Object)event.getField(Event.Fields.PRIORITY)).asString("")));
        stm.addBatch();
        try {
            stm.executeBatch();
        }
        catch (SQLException e) {
            this.logSQLError(e);
            throw e;
        }
        stm1 = stm;
        stm = con.prepareStatement(String.format("INSERT INTO %sES_AE_EVENTS_ATTR (ID, KEY, VALUE_TYPE, VALUE_STRING, VALUE_INTEGER, VALUE_DOUBLE) VALUES (?, ?, ?, ?, ?, ?)", this.getSchema()));
        boolean hasAttr = false;
        for (String attr : event.getAttributes().keySet()) {
            if (SqlConverter.inlinedAttributes.contains(attr)) continue;
            stm.setString(1, event.getId().toString());
            stm.setString(2, attr);
            stm.setString(3, this.clip(32, ((Variant)event.getAttributes().get(attr)).getType().name()));
            stm.setString(4, this.clip(this.getMaxLength(), ((Variant)event.getAttributes().get(attr)).asString("")));
            Long longValue2 = Variant.valueOf(event.getAttributes().get(attr)).asLong(null);
            if (longValue2 == null) {
                stm.setNull(5, -5);
            } else {
                stm.setLong(5, longValue2);
            }
            Double doubleValue2 = Variant.valueOf(event.getAttributes().get(attr)).asDouble(null);
            if (doubleValue2 == null) {
                stm.setNull(6, 8);
            } else {
                stm.setDouble(6, doubleValue2);
            }
            stm.addBatch();
            hasAttr = true;
        }
        if (hasAttr) {
            try {
                stm.executeBatch();
            }
            catch (SQLException e) {
                this.logSQLError(e);
                throw e;
            }
        }
        stm2 = stm;
        this.closeStatement(stm1);
        this.closeStatement(stm2);
    }

    protected void logSQLError(SQLException e) {
        SQLException ex = e;
        while (ex != null) {
            logger.info("Batch update - next exception", (Throwable)ex);
            ex = ex.getNextException();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Event loadEvent(UUID id) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultSet queryEvents(Filter filter) throws SQLException, NotSupportedException {
        Connection con = this.createConnection();
        con.setAutoCommit(Boolean.getBoolean("org.eclipse.scada.ae.server.storage.jdbc.query.autoCommit"));
        SqlCondition condition = SqlConverter.toSql(this.getSchema(), filter);
        String sql = String.valueOf("SELECT E.ID, E.INSTANCE_ID, E.SOURCE_TIMESTAMP, E.ENTRY_TIMESTAMP, E.MONITOR_TYPE, E.EVENT_TYPE, E.VALUE_TYPE, E.VALUE_STRING, E.VALUE_INTEGER, E.VALUE_DOUBLE, E.MESSAGE, E.MESSAGE_CODE, E.PRIORITY, E.SOURCE, E.ACTOR_NAME, E.ACTOR_TYPE, E.SEVERITY, A.KEY, A.VALUE_TYPE, A.VALUE_STRING, A.VALUE_INTEGER, A.VALUE_DOUBLE FROM %1$sES_AE_EVENTS E LEFT JOIN %1$sES_AE_EVENTS_ATTR A ON (A.ID = E.ID) ") + StringHelper.join(condition.joins, (String)" ") + " WHERE E.INSTANCE_ID = ? ";
        sql = String.valueOf(sql) + condition.condition;
        sql = String.valueOf(sql) + " ORDER BY E.SOURCE_TIMESTAMP DESC, E.ENTRY_TIMESTAMP DESC";
        String querySql = String.format(sql, this.getSchema());
        logger.debug("executing query: {} with parameters {} / {}", new Object[]{querySql, condition.joinParameters, condition.parameters});
        PreparedStatement stm = con.prepareStatement(querySql, 1003, 1007);
        stm.setFetchSize(Integer.getInteger("org.eclipse.scada.ae.server.storage.jdbc.query.fetchSize", 1000));
        int i = 0;
        for (String string : condition.joinParameters) {
            stm.setString(++i, string);
        }
        stm.setString(++i, this.getInstance());
        for (Serializable serializable : condition.parameters) {
            stm.setObject(++i, serializable);
        }
        ResultSet resultSet = stm.executeQuery();
        logger.debug("query completed, returning resultset");
        return resultSet;
    }

    @Override
    public boolean toEventList(ResultSet rs, Collection<Event> events, boolean isBeforeFirst, long count) throws SQLException {
        UUID lastId = null;
        Event.EventBuilder eb = Event.create();
        boolean hasMore = true;
        long l = 0L;
        while (!isBeforeFirst || (hasMore = rs.next())) {
            UUID id = UUID.fromString(rs.getString(1));
            if (lastId != null && !id.equals(lastId)) {
                events.add(eb.build());
                if (++l == count) break;
                lastId = id;
                eb = Event.create();
            } else if (lastId == null) {
                lastId = id;
            }
            eb.id(id);
            java.util.Date sourceTimestamp = new java.util.Date(rs.getTimestamp(3).getTime());
            java.util.Date entryTimestamp = new java.util.Date(rs.getTimestamp(4).getTime());
            String monitorType = this.intern(rs.getString(5));
            String eventType = this.intern(rs.getString(6));
            String valueType = this.intern(rs.getString(7));
            String valueString = this.intern(rs.getString(8));
            String message = rs.getString(11);
            String messageCode = this.intern(rs.getString(12));
            Integer priority = rs.getInt(13);
            String source = this.intern(rs.getString(14));
            String actor = this.intern(rs.getString(15));
            String actorType = this.intern(rs.getString(16));
            String severity = this.intern(rs.getString(17));
            eb.sourceTimestamp(sourceTimestamp);
            eb.entryTimestamp(entryTimestamp);
            eb.attribute(Event.Fields.MONITOR_TYPE, (Object)monitorType);
            eb.attribute(Event.Fields.EVENT_TYPE, (Object)eventType);
            if (valueType != null && valueString != null) {
                eb.attribute(Event.Fields.VALUE, VariantEditor.toVariant((String)valueType, (String)valueString));
            }
            eb.attribute(Event.Fields.MESSAGE, (Object)message);
            eb.attribute(Event.Fields.MESSAGE_CODE, (Object)messageCode);
            eb.attribute(Event.Fields.PRIORITY, (Object)priority);
            eb.attribute(Event.Fields.SOURCE, (Object)source);
            eb.attribute(Event.Fields.ACTOR_NAME, (Object)actor);
            eb.attribute(Event.Fields.ACTOR_TYPE, (Object)actorType);
            eb.attribute(Event.Fields.SEVERITY, (Object)severity);
            String field = this.intern(rs.getString(18));
            valueType = this.intern(rs.getString(19));
            valueString = rs.getString(20);
            if (field != null) {
                if (valueType != null && valueString != null) {
                    eb.attribute(field, VariantEditor.toVariant((String)valueType, (String)valueString));
                } else {
                    eb.attribute(field, Variant.NULL);
                }
            }
            if (hasMore = rs.next()) continue;
            events.add(eb.build());
            break;
        }
        return hasMore;
    }

    protected String intern(String string) {
        return (String)this.stringInterner.intern((Object)string);
    }

    @Override
    protected String getDeleteAttributesSql() {
        return "DELETE FROM %sES_AE_EVENTS_ATTR WHERE ID = ? AND KEY = ?";
    }

    @Override
    protected String getInsertAttributesSql() {
        return "INSERT INTO %sES_AE_EVENTS_ATTR (ID, KEY, VALUE_TYPE, VALUE_STRING, VALUE_INTEGER, VALUE_DOUBLE) VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public void cleanupArchive() {
        try {
            this.cleanupArchive(this.getCleanupDays());
        }
        catch (Exception e) {
            logger.error("Failed to clean up archive", (Throwable)e);
        }
    }

    protected int cleanupArchive(int days) throws Exception {
        logger.info("Request to clean up archive - days: {}", (Object)days);
        if (days <= 0) {
            logger.info("Skipping archive cleanup");
            return -1;
        }
        final Calendar c = Calendar.getInstance();
        c.add(5, -days);
        return (Integer)this.getAccessor().doWithConnection((ConnectionTask)new CommonConnectionTask<Integer>(){

            protected Integer performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.setAutoCommit(true);
                Date d = new Date(c.getTimeInMillis());
                logger.info("Starting to delete events up to {}", (Object)d);
                int result = connectionContext.update(String.format("DELETE FROM %sES_AE_EVENTS WHERE ENTRY_TIMESTAMP < ?", AbstractJdbcStorageDao.this.getSchema()), new Object[]{d});
                logger.info("Successfully cleaned up {} entries", (Object)result);
                return result;
            }
        });
    }

    protected void performStoreEvent(Event event, ConnectionContext connectionContext) throws SQLException, Exception {
        this.storeEventData(event, connectionContext.getConnection());
    }

    private static enum ReplicationDataFormat {
        BLOB,
        BYTES;

    }
}

