/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.rest;

import org.eclipse.scada.utils.ExceptionHelper;

public class WriteResult {
    private String errorInformation;
    private String stackStrace;

    public WriteResult(Throwable error) {
        if (error != null) {
            this.errorInformation = ExceptionHelper.getMessage((Throwable)error);
            this.stackStrace = ExceptionHelper.formatted((Throwable)error);
        }
    }

    public WriteResult() {
    }

    public void setErrorInformation(String errorInformation) {
        this.errorInformation = errorInformation;
    }

    public String getErrorInformation() {
        return this.errorInformation;
    }

    public void setStackStrace(String stackStrace) {
        this.stackStrace = stackStrace;
    }

    public String getStackStrace() {
        return this.stackStrace;
    }

    public boolean isError() {
        return this.errorInformation != null;
    }

    public String toString() {
        if (this.errorInformation == null) {
            return "[OK]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[Error: " + this.errorInformation);
        if (this.stackStrace != null) {
            sb.append("\n");
            sb.append(this.stackStrace);
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

