/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.io.common;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.io.common.BaseDevice;
import org.eclipse.scada.da.server.io.common.ConnectionListener;
import org.eclipse.scada.da.server.io.common.ConnectionState;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDeviceWrapper
implements ConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(BaseDeviceWrapper.class);
    protected static final int RECONNECT_DELAY = 5000;
    protected String deviceTag;
    private final HiveCommon hive;
    private final FolderCommon rootFolder;
    protected FolderCommon baseFolder;
    protected ConnectionState state = ConnectionState.DISCONNECTED;
    private final ScheduledExecutorService scheduler;
    private BaseDevice device;
    private final DataItemInputChained connectionStateItem;
    private final DataItemInputChained stateItem;
    private final DataItemInputChained timeoutItem;
    private ScheduledFuture<?> tickJob;
    private long lastReply = 0L;
    private boolean timeout = false;
    private static final int JOB_PERIOD = 1000;

    public BaseDeviceWrapper(HiveCommon hive, String deviceTag, ScheduledExecutorService scheduler, FolderCommon rootFolder) {
        this.hive = hive;
        this.deviceTag = deviceTag;
        this.rootFolder = rootFolder;
        this.scheduler = scheduler;
        this.baseFolder = new FolderCommon();
        this.rootFolder.add(this.deviceTag, (Folder)this.baseFolder, new MapBuilder().getMap());
        this.connectionStateItem = this.createInput("connection");
        this.stateItem = this.createInput("state");
        this.timeoutItem = this.createInput("timeout");
    }

    protected void tick() {
        this.updateTimeoutCondition();
        this.updateDeviceState();
    }

    public void start() {
        if (this.device != null) {
            throw new RuntimeException("Device is already initialized");
        }
        this.tickJob = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseDeviceWrapper.this.tick();
                }
                catch (Throwable e) {
                    logger.debug("Failed to tick", e);
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.setConnectionState(ConnectionState.DISCONNECTED);
        this.device = this.createDevice();
        this.device.addConnectionListener(this);
        this.connect();
    }

    public void stop() {
        if (this.device != null) {
            this.tickJob.cancel(false);
            this.device.dispose();
            this.setConnectionState(ConnectionState.DISCONNECTED);
            this.rootFolder.remove((Folder)this.baseFolder);
        }
        this.device = null;
    }

    protected abstract BaseDevice createDevice();

    public String getItemId(String item) {
        return String.valueOf(this.deviceTag) + "." + item;
    }

    protected DataItemInputChained createInput(String itemName) {
        DataItemInputChained item = new DataItemInputChained(this.getItemId(itemName), this.hive.getOperationService());
        this.hive.registerItem((DataItem)item);
        this.baseFolder.add(itemName, (DataItem)item, new MapBuilder().getMap());
        return item;
    }

    protected DataItemCommand createCommand(String itemName) {
        DataItemCommand item = new DataItemCommand(this.getItemId(itemName), this.hive.getOperationService());
        this.hive.registerItem((DataItem)item);
        this.baseFolder.add(itemName, (DataItem)item, new MapBuilder().getMap());
        return item;
    }

    protected synchronized void setConnectionState(ConnectionState state) {
        logger.debug("Setting state to: {}", (Object)state);
        this.onPreStateChange(this.state, state);
        this.state = state;
        this.connectionStateItem.updateData(Variant.valueOf((Object)state.name()), null, null);
        this.onPostStateChange();
    }

    protected void onPostStateChange() {
    }

    protected void onPreStateChange(ConnectionState oldState, ConnectionState newState) {
    }

    protected synchronized void connect() {
        if (this.device == null) {
            return;
        }
        if (!this.device.isConnected()) {
            this.device.connect();
            this.setConnectionState(ConnectionState.CONNECTING);
        }
    }

    protected synchronized void reconnect() {
        if (this.state.equals((Object)ConnectionState.DISCONNECTED)) {
            if (this.device == null) {
                return;
            }
            this.setConnectionState(ConnectionState.WAITING);
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    BaseDeviceWrapper.this.connect();
                }
            }, 5000L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isConnected() {
        return this.state.equals((Object)ConnectionState.CONNECTED);
    }

    @Override
    public void closed(Throwable error) {
        this.setConnectionState(ConnectionState.DISCONNECTED);
        this.reconnect();
    }

    @Override
    public void connectFailed(Throwable error) {
        this.setConnectionState(ConnectionState.DISCONNECTED);
        this.reconnect();
    }

    @Override
    public void opened() {
        this.setConnectionState(ConnectionState.CONNECTED);
    }

    private void updateDeviceState() {
        this.stateItem.updateData(Variant.valueOf((boolean)this.isDeviceOk()), null, null);
    }

    public boolean isDeviceOk() {
        return !this.isTimeout() && this.isConnected();
    }

    public boolean isTimeoutCondition() {
        return System.currentTimeMillis() - this.lastReply > this.getTimeoutValue();
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    protected abstract long getTimeoutValue();

    protected void tickLastInput() {
        this.lastReply = System.currentTimeMillis();
        this.updateTimeoutCondition();
        this.updateDeviceState();
    }

    private synchronized void updateTimeoutCondition() {
        if (this.isTimeout() != this.isTimeoutCondition()) {
            this.timeout = this.isTimeoutCondition();
            this.onTimeout(this.isTimeout());
        }
        this.timeoutItem.updateData(Variant.valueOf((boolean)this.isTimeout()), null, null);
    }

    protected void onTimeout(boolean timeout) {
    }

    protected HiveCommon getHive() {
        return this.hive;
    }
}

