/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus.io;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.exporter.modbus.io.AbstractSourceType;
import org.eclipse.scada.da.server.exporter.modbus.io.SourceType;

public class IntegerType
extends AbstractSourceType {
    private final Double factor;
    private static final int DATA_LENGTH = 4;
    public static final int LENGTH = 14;
    public static final SourceType INSTANCE = new IntegerType();

    public IntegerType(Double factor) {
        super(4);
        this.factor = factor;
    }

    public IntegerType() {
        this(null);
    }

    @Override
    public void putValue(IoBuffer slice, Variant value) {
        slice.putInt(this.makeValue(value));
    }

    @Override
    public Variant getValue(int localOffset, IoBuffer value) {
        if (localOffset == 10 && value.remaining() == 4) {
            return Variant.valueOf((int)value.getInt());
        }
        return null;
    }

    private int makeValue(Variant value) {
        if (value == null) {
            return 0;
        }
        if (this.factor == null) {
            Integer v = value.asInteger(null);
            if (v == null) {
                return 0;
            }
            return v;
        }
        Double v = value.asDouble(null);
        if (v == null) {
            return 0;
        }
        return (int)(this.factor * v);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.factor == null ? 0 : this.factor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerType)) {
            return false;
        }
        IntegerType other = (IntegerType)obj;
        return !(this.factor == null ? other.factor != null : !this.factor.equals(other.factor));
    }
}

