/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.common;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.SSLSession;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.client.NoConnectionException;
import org.eclipse.scada.core.client.PrivilegeListener;
import org.eclipse.scada.core.client.common.BaseConnection;
import org.eclipse.scada.core.client.common.IoHandlerFactory;
import org.eclipse.scada.core.client.common.StateNotifier;
import org.eclipse.scada.protocol.common.IoLoggerFilterChainBuilder;
import org.eclipse.scada.protocol.common.StatisticsFilter;
import org.eclipse.scada.sec.callback.CallbackFactory;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBaseConnection
extends BaseConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(ClientBaseConnection.class);
    private static final Object STATS_CACHE_ADDRESS = new Object();
    private static final Object STATS_CURRENT_STATE = new Object();
    private static final Object STATS_CONNECT_CALLS = new Object();
    private static final Object STATS_DISCONNECT_CALLS = new Object();
    private static final Object STATS_MESSAGES_SENT = new Object();
    private static final Object STATS_MESSAGES_RECEIVED = new Object();
    private static final Object STATS_CREATION_TIMESTAMP = new Object();
    private static final Object STATS_LAST_CONNECT_TIMESTAMP = new Object();
    private static final Object STATS_LAST_BOUND_TIMESTAMP = new Object();
    private final SocketConnector connector;
    private volatile ConnectionState connectionState = ConnectionState.CLOSED;
    private InetAddress addressCache;
    private ConnectFuture connectFuture;
    private IoSession session;
    private final StateNotifier stateNotifier;
    private final IoHandler handler;
    private final IoLoggerFilterChainBuilder chainBuilder;
    private final Set<PrivilegeListener> privilegeListeners = new LinkedHashSet<PrivilegeListener>();
    private volatile Set<String> currentPrivileges;
    private final Object writeLock = new Object();
    protected volatile CallbackHandler connectCallbackHandler;
    protected CallbackFactory callbackFactory;
    private volatile boolean disposed;
    private final boolean cacheAddress = Boolean.getBoolean("org.eclipse.scada.core.client.common.cacheAddress");

    public ClientBaseConnection(IoHandlerFactory handlerFactory, IoLoggerFilterChainBuilder chainBuilder, ConnectionInformation connectionInformation) throws Exception {
        this(handlerFactory, chainBuilder, connectionInformation, null);
    }

    protected ClientBaseConnection(IoHandlerFactory handlerFactory, IoLoggerFilterChainBuilder chainBuilder, ConnectionInformation connectionInformation, IoProcessor<NioSession> processor) throws Exception {
        super(connectionInformation);
        this.stateNotifier = new StateNotifier(this.executor, this);
        this.handler = handlerFactory.create(this);
        this.connector = processor != null ? new NioSocketConnector(processor) : new NioSocketConnector();
        this.chainBuilder = chainBuilder;
        this.chainBuilder.setLoggerName(String.valueOf(ClientBaseConnection.class.getName()) + ".protocol");
        this.connector.setFilterChainBuilder((IoFilterChainBuilder)this.chainBuilder);
        this.connector.setHandler(this.handler);
        this.statistics.setLabel(STATS_CACHE_ADDRESS, "Flag if the IP address gets cached");
        this.statistics.setCurrentValue(STATS_CACHE_ADDRESS, this.cacheAddress ? 1.0 : 0.0);
        this.statistics.setLabel(STATS_CURRENT_STATE, "Numeric connection state");
        this.statistics.setLabel(STATS_CONNECT_CALLS, "Calls to connect");
        this.statistics.setLabel(STATS_DISCONNECT_CALLS, "Calls to disconnect");
        this.statistics.setLabel(STATS_MESSAGES_SENT, "Messages sent");
        this.statistics.setLabel(STATS_MESSAGES_RECEIVED, "Messages received");
        this.statistics.setLabel(STATS_CREATION_TIMESTAMP, "Timestamp of creation (in seconds)");
        this.statistics.setCurrentValue(STATS_CREATION_TIMESTAMP, Math.floor(System.currentTimeMillis() / 1000L));
        this.statistics.setLabel(STATS_LAST_CONNECT_TIMESTAMP, "Timestamp of last CONNECT (in seconds)");
        this.statistics.setLabel(STATS_LAST_BOUND_TIMESTAMP, "Timestamp of last BOUND (in seconds)");
    }

    public void setCallbackFactory(CallbackFactory callbackFactory) {
        this.callbackFactory = callbackFactory;
    }

    public void connect() {
        this.statistics.changeCurrentValue(STATS_CONNECT_CALLS, 1.0);
        this.switchState(ConnectionState.CONNECTING, null);
    }

    public void connect(CallbackHandler callbackHandler) {
        this.connectCallbackHandler = callbackHandler;
        this.connect();
    }

    public void disconnect() {
        this.statistics.changeCurrentValue(STATS_DISCONNECT_CALLS, 1.0);
        this.switchState(ConnectionState.CLOSING, null);
    }

    protected synchronized void switchState(ConnectionState state, Throwable error) {
        logger.debug("Switching state : {} -> {}", (Object)this.connectionState, (Object)state);
        ConnectionState oldState = this.connectionState;
        if (oldState == state) {
            return;
        }
        switch (oldState) {
            case CLOSED: {
                this.switchFromClosed(state, error);
                break;
            }
            case CONNECTED: {
                this.switchFromConnected(state, error);
                break;
            }
            case CONNECTING: {
                this.switchFromConnecting(state, error);
                break;
            }
            case BOUND: {
                this.switchFromBound(state, error);
                break;
            }
            case CLOSING: {
                break;
            }
            case LOOKUP: {
                this.switchFromLookup(state, error);
            }
        }
    }

    private void switchFromConnecting(ConnectionState state, Throwable error) {
        switch (state) {
            case CLOSED: {
                this.performDisconnected(error);
                break;
            }
            case CONNECTED: {
                this.handleConnected();
                break;
            }
            case CLOSING: {
                this.requestClose();
            }
        }
    }

    private void handleConnected() {
        this.statistics.setCurrentValue(STATS_LAST_CONNECT_TIMESTAMP, Math.floor(System.currentTimeMillis() / 1000L));
        this.setState(ConnectionState.CONNECTED, null);
        this.onConnectionConnected();
    }

    protected void onConnectionBound() {
    }

    protected void onConnectionConnected() {
        this.switchState(ConnectionState.BOUND, null);
    }

    protected void onConnectionClosed() {
        this.connectCallbackHandler = null;
        this.firePrivilegeChange(Collections.emptySet());
    }

    private void switchFromBound(ConnectionState state, Throwable error) {
        switch (state) {
            case CLOSING: {
                this.requestClose();
                break;
            }
            case CLOSED: {
                this.performDisconnected(error);
            }
        }
    }

    private void switchFromLookup(ConnectionState state, Throwable error) {
        switch (state) {
            case CLOSED: 
            case CLOSING: {
                this.performDisconnected(error);
            }
        }
    }

    private void switchFromConnected(ConnectionState state, Throwable error) {
        switch (state) {
            case CLOSING: {
                this.requestClose();
                break;
            }
            case CLOSED: {
                this.performDisconnected(error);
                break;
            }
            case BOUND: {
                this.performBound();
            }
        }
    }

    private void performBound() {
        this.connectCallbackHandler = null;
        this.statistics.setCurrentValue(STATS_LAST_BOUND_TIMESTAMP, Math.floor(System.currentTimeMillis() / 1000L));
        this.setState(ConnectionState.BOUND, null);
        this.onConnectionBound();
    }

    private void requestClose() {
        if (this.session != null) {
            this.session.close(false);
        } else {
            logger.debug("We have no session. Perform disconnected instead!");
            this.performDisconnected(null);
        }
    }

    protected synchronized void performDisconnected(Throwable error) {
        logger.debug("Perform disconnected", error);
        this.connectCallbackHandler = null;
        if (this.session != null) {
            logger.debug("Clear session");
            this.session.close(true);
            this.session.removeAttribute((Object)StatisticsFilter.STATS_KEY);
            this.session = null;
        }
        this.setState(ConnectionState.CLOSED, error);
        this.onConnectionClosed();
    }

    private void switchFromClosed(ConnectionState state, Throwable error) {
        switch (state) {
            case CONNECTING: {
                this.initConnect();
            }
        }
    }

    private void initConnect() {
        if (this.addressCache == null) {
            this.beginLookup();
        } else {
            this.startConnect(this.addressCache);
        }
    }

    private synchronized void startConnect(InetAddress address) {
        logger.debug("Start connection to {}", (Object)address);
        this.setState(ConnectionState.CONNECTING, null);
        this.connectFuture = this.connector.connect((SocketAddress)new InetSocketAddress(address, (int)this.connectionInformation.getSecondaryTarget()));
        logger.trace("Returned from connect call");
        this.connectFuture.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                ClientBaseConnection.this.handleConnectComplete(future);
            }
        });
        logger.trace("Future listener registered");
    }

    protected synchronized void handleConnectComplete(ConnectFuture future) {
        logger.debug("Connection attempt complete: {}", (Object)future);
        if (this.connectFuture != future) {
            logger.warn("handleConnectComplete got called with wrong future - current: {}, called: {}", (Object)this.connectFuture, (Object)future);
            return;
        }
        this.connectFuture = null;
        Throwable error = future.getException();
        if (error != null) {
            this.setState(ConnectionState.CLOSED, error);
            return;
        }
        try {
            this.setSession(future.getSession());
        }
        catch (Throwable e) {
            this.setState(ConnectionState.CLOSED, e);
        }
        logger.debug("Connection established");
    }

    private void setSession(IoSession session) {
        logger.debug("Setting session: {}", (Object)session);
        if (this.session != null) {
            logger.warn("Failed to set session ... there is still one set");
        }
        this.session = session;
        this.session.setAttribute((Object)StatisticsFilter.STATS_KEY, (Object)this.statistics);
    }

    private void beginLookup() {
        this.setState(ConnectionState.LOOKUP, null);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ClientBaseConnection.this.performLookup(ClientBaseConnection.this.connectionInformation.getTarget());
            }
        });
    }

    private void performLookup(String host) {
        InetAddress address;
        logger.info("Beginning lookup of '{}'", (Object)host);
        try {
            address = InetAddress.getByName(host);
        }
        catch (Throwable e) {
            this.endLookup(null, e);
            return;
        }
        try {
            this.endLookup(address, null);
        }
        catch (Throwable e) {
            this.setState(ConnectionState.CLOSED, e);
        }
    }

    private synchronized void endLookup(InetAddress address, Throwable error) {
        logger.debug("endLookup - address: {}, error: {}", (Object)address, (Object)error);
        if (this.connectionState != ConnectionState.LOOKUP) {
            logger.warn("Lookup ended but we are not tryining to connet anymore. Might be OK if somebody disconnected.");
            return;
        }
        if (address != null) {
            if (this.cacheAddress) {
                this.addressCache = address;
            }
            this.startConnect(address);
        } else {
            this.setState(ConnectionState.CLOSED, error);
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public synchronized void dispose() {
        this.disposed = true;
        this.performDisconnected(null);
        this.stateNotifier.dispose();
        this.connector.dispose();
        super.dispose();
        this.chainBuilder.dispose();
    }

    protected synchronized void setState(ConnectionState connectionState, Throwable error) {
        logger.debug("Setting state - {} -> {}", (Object)this.connectionState, (Object)connectionState);
        this.statistics.setCurrentValue(STATS_CURRENT_STATE, (double)connectionState.ordinal());
        if (this.connectionState == connectionState) {
            return;
        }
        this.connectionState = connectionState;
        this.stateNotifier.fireConnectionStateChange(connectionState, error);
    }

    public void addConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.stateNotifier.addConnectionStateListener(connectionStateListener);
    }

    public void removeConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.stateNotifier.removeConnectionStateListener(connectionStateListener);
    }

    public ConnectionState getState() {
        return this.connectionState;
    }

    protected synchronized void performClosed(IoSession session, Throwable error) {
        if (this.session == null) {
            logger.debug("We seem already closed");
        } else if (this.session != session) {
            logger.warn("Received 'closed' from wrong session");
            return;
        }
        this.performDisconnected(error);
    }

    public synchronized void performOpened(IoSession session) {
        if (this.session != session) {
            logger.warn("Received 'opened' from wrong session (ours: {}, theirs: {})", (Object)this.session, (Object)session);
            return;
        }
        this.switchState(ConnectionState.CONNECTED, null);
    }

    public synchronized void messageReceived(IoSession session, Object message) {
        logger.trace("Received message: {}", message);
        if (this.session != session) {
            logger.warn("Received 'message' from wrong session (current: {}, message: {})", (Object)this.session, (Object)session);
            return;
        }
        this.statistics.changeCurrentValue(STATS_MESSAGES_RECEIVED, 1.0);
        this.handleMessage(message);
    }

    protected abstract void handleMessage(Object var1);

    protected synchronized void sendMessageChecked(Object message) throws NoConnectionException {
        logger.debug("Sending message: {}", message);
        if (this.session == null) {
            logger.warn("Failed to send message without connection: {}", message);
            throw new NoConnectionException();
        }
        if (this.getState() != ConnectionState.BOUND && this.getState() != ConnectionState.CONNECTED) {
            logger.warn("Tried to send message in wrong connection state ({}): {}", (Object)this.getState(), message);
            throw new NoConnectionException();
        }
        this.processSendMessage(message);
    }

    protected synchronized void sendMessage(Object message) {
        logger.debug("Sending message: {}", message);
        if (this.session == null) {
            logger.warn("Failed to send message without connection: {}", message);
            return;
        }
        if (this.getState() != ConnectionState.BOUND && this.getState() != ConnectionState.CONNECTED) {
            logger.warn("Tried to send message in wrong connection state ({}): {}", (Object)this.getState(), message);
            return;
        }
        this.processSendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSendMessage(Object message) {
        this.statistics.changeCurrentValue(STATS_MESSAGES_SENT, 1.0);
        Object object = this.writeLock;
        synchronized (object) {
            this.session.write(message);
        }
    }

    public SSLSession getSslSession() {
        IoSession session = this.session;
        if (session == null) {
            return null;
        }
        Object sslSession = session.getAttribute((Object)SslFilter.SSL_SESSION);
        if (sslSession instanceof SSLSession) {
            return (SSLSession)sslSession;
        }
        return null;
    }

    public synchronized void addPrivilegeListener(final PrivilegeListener listener) {
        if (this.privilegeListeners.add(listener)) {
            final Set<String> granted = this.currentPrivileges;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.privilegesChanged(granted);
                }
            });
        }
    }

    public synchronized void removePrivilegeListener(PrivilegeListener listener) {
        this.privilegeListeners.remove(listener);
    }

    public Set<String> getPrivileges() {
        return Collections.unmodifiableSet(this.currentPrivileges);
    }

    protected synchronized void firePrivilegeChange(final Set<String> granted) {
        this.currentPrivileges = granted;
        for (final PrivilegeListener listener : this.privilegeListeners) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.privilegesChanged(granted);
                }
            });
        }
    }

    protected IoSession getSession() {
        return this.session;
    }
}

