/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.mapper.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.mapper.ValueMapper;
import org.eclipse.scada.da.mapper.osgi.ca.ConfiguredValueMapperFactory;
import org.eclipse.scada.da.mapper.osgi.jdbc.JdbcValueMapperFactory;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ObjectPoolImpl<ValueMapper> mapperPool;
    private ServiceRegistration<?> mapperPoolRegistration;
    private ConfiguredValueMapperFactory factory1;
    private ObjectPoolImpl<DataItem> itemPool;
    private ServiceRegistration<?> itemPoolRegistration;
    private JdbcValueMapperFactory factory2;

    public void start(BundleContext context) throws Exception {
        this.mapperPool = new ObjectPoolImpl();
        this.mapperPoolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.mapperPool, ValueMapper.class);
        this.itemPool = new ObjectPoolImpl();
        this.itemPoolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.itemPool, DataItem.class);
        this.factory1 = new ConfiguredValueMapperFactory(context, (ManageableObjectPool<ValueMapper>)this.mapperPool);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "A value mapper based on its configuration");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.mapper.osgi.configuredMapper");
        context.registerService(ConfigurationFactory.class.getName(), (Object)this.factory1, properties);
        this.factory2 = new JdbcValueMapperFactory(context, (ManageableObjectPool<ValueMapper>)this.mapperPool, this.itemPool);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.description", "A value mapper based on a jdbc sql query");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.mapper.osgi.jdbcMapper");
        context.registerService(ConfigurationFactory.class.getName(), (Object)this.factory2, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.factory1.dispose();
        this.factory2.dispose();
        this.mapperPoolRegistration.unregister();
        this.mapperPool.dispose();
        this.itemPoolRegistration.unregister();
        this.itemPool.dispose();
    }
}

