/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component.parser.factory.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariantType implements Enumerator
{
    DEFAULT(0, "DEFAULT", "DEFAULT"),
    STRING(1, "STRING", "STRING"),
    INT32(2, "INT32", "INT32"),
    INT64(3, "INT64", "INT64"),
    DOUBLE(4, "DOUBLE", "DOUBLE"),
    BOOLEAN(5, "BOOLEAN", "BOOLEAN");

    public static final int DEFAULT_VALUE = 0;
    public static final int STRING_VALUE = 1;
    public static final int INT32_VALUE = 2;
    public static final int INT64_VALUE = 3;
    public static final int DOUBLE_VALUE = 4;
    public static final int BOOLEAN_VALUE = 5;
    private static final VariantType[] VALUES_ARRAY;
    public static final List<VariantType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariantType[]{DEFAULT, STRING, INT32, INT64, DOUBLE, BOOLEAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariantType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariantType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariantType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariantType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariantType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return INT32;
            }
            case 3: {
                return INT64;
            }
            case 4: {
                return DOUBLE;
            }
            case 5: {
                return BOOLEAN;
            }
        }
        return null;
    }

    private VariantType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

