/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.impl.stats;

import org.eclipse.scada.da.server.common.impl.stats.CounterOutput;
import org.eclipse.scada.da.server.common.impl.stats.Tickable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterValue
implements Tickable {
    private static final Logger logger = LoggerFactory.getLogger(CounterValue.class);
    private long total = 0L;
    private long lastTickValue = 0L;
    private long lastTimestamp = 0L;
    private CounterOutput output;

    public synchronized void add(long value) {
        this.total += value;
        this.lastTickValue += Math.abs(value);
        logger.debug("Adding: {}, LastTickValue: {}", (Object)value, (Object)this.lastTickValue);
    }

    @Override
    public synchronized void tick() {
        long ts = System.currentTimeMillis();
        long diff = (ts - this.lastTimestamp) / 1000L;
        this.lastTimestamp = ts;
        if (diff == 0L) {
            diff = 1L;
        }
        long lastTickValue = this.lastTickValue;
        this.lastTickValue = 0L;
        double avg = (double)lastTickValue / (double)diff;
        logger.debug("LastTickValue: {}, Diff: {}, Avg: {}", new Object[]{lastTickValue, diff, avg});
        this.output.setTickValue(avg, this.total);
    }

    public void setOutput(CounterOutput output) {
        this.output = output;
    }
}

