/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.server.MonitorListener;
import org.eclipse.scada.ae.server.common.monitor.MonitorQuery;
import org.eclipse.scada.ae.server.common.monitor.MonitorQueryListener;
import org.eclipse.scada.core.subscription.SubscriptionInformation;
import org.eclipse.scada.core.subscription.SubscriptionSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorQuerySource
implements SubscriptionSource<String>,
MonitorQueryListener {
    private static final Logger logger = LoggerFactory.getLogger(MonitorQuerySource.class);
    private final MonitorQuery monitorQuery;
    private final Set<MonitorListener> listeners = new HashSet<MonitorListener>();
    private final Map<String, MonitorStatusInformation> cachedData = new HashMap<String, MonitorStatusInformation>();
    private final String queryId;

    public MonitorQuerySource(String queryId, MonitorQuery monitorQuery) {
        this.queryId = queryId;
        this.monitorQuery = monitorQuery;
    }

    public synchronized void addListener(Collection<SubscriptionInformation<String>> listeners) {
        boolean wasEmpty = this.listeners.isEmpty();
        for (SubscriptionInformation<String> information : listeners) {
            MonitorListener listener = (MonitorListener)information.getListener();
            this.listeners.add(listener);
            if (this.cachedData.isEmpty()) continue;
            listener.dataChanged(this.queryId, new ArrayList<MonitorStatusInformation>(this.cachedData.values()), null, true);
        }
        if (wasEmpty && !this.listeners.isEmpty()) {
            this.monitorQuery.addListener(this);
        }
    }

    public synchronized void removeListener(Collection<SubscriptionInformation<String>> listeners) {
        for (SubscriptionInformation<String> information : listeners) {
            MonitorListener listener = (MonitorListener)information.getListener();
            this.listeners.remove(listener);
        }
        if (this.listeners.isEmpty()) {
            this.monitorQuery.removeListener(this);
            this.cachedData.clear();
        }
    }

    public boolean supportsListener(SubscriptionInformation<String> subscriptionInformation) {
        return subscriptionInformation.getListener() instanceof MonitorListener;
    }

    @Override
    public synchronized void dataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        if (full) {
            this.cachedData.clear();
        }
        if (removed != null) {
            for (String id : removed) {
                this.cachedData.remove(id);
            }
        }
        if (addedOrUpdated != null) {
            for (MonitorStatusInformation info : addedOrUpdated) {
                this.cachedData.put(info.getId(), info);
            }
        }
        for (MonitorListener listener : this.listeners) {
            try {
                listener.dataChanged(this.queryId, addedOrUpdated, removed, full);
            }
            catch (Throwable e) {
                logger.warn("Failed to notify", e);
            }
        }
    }
}

