/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.item;

import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.item.DataItemTargetImpl;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class DataItemTargetFactoryImpl
extends AbstractServiceConfigurationFactory<DataItemTargetImpl> {
    public static final String FACTORY_ID = "da.dataitem.datasource";
    private final BundleContext context;
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final ObjectPoolImpl<DataItem> itemPool = new ObjectPoolImpl();
    private final ServiceRegistration<?> itemPoolHandle;

    public DataItemTargetFactoryImpl(BundleContext context) throws InvalidSyntaxException {
        super(context);
        this.itemPoolHandle = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.itemPool, DataItem.class);
        this.context = context;
        this.poolTracker = new ObjectPoolTracker(context, DataSource.class);
        this.poolTracker.open();
    }

    public synchronized void dispose() {
        this.itemPoolHandle.unregister();
        this.itemPool.dispose();
        this.poolTracker.close();
        super.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<DataItemTargetImpl> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        return this.createDataItem(configurationId, context, parameters);
    }

    protected void disposeService(UserInformation userInformation, String id, DataItemTargetImpl service) {
        this.itemPool.removeService(id, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<DataItemTargetImpl> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<DataItemTargetImpl> entry, Map<String, String> parameters) throws Exception {
        this.itemPool.removeService(configurationId, (Object)((DataItem)entry.getService()));
        ((DataItemTargetImpl)((Object)entry.getService())).dispose();
        return this.createDataItem(configurationId, this.context, parameters);
    }

    protected AbstractServiceConfigurationFactory.Entry<DataItemTargetImpl> createDataItem(String configurationId, BundleContext context, Map<String, String> parameters) throws InvalidSyntaxException {
        EnumSet<IODirection> ioDirection;
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        String itemId = cfg.getStringChecked("item.id", "'item.id' must be set");
        String io = cfg.getString("io.directions");
        if (io != null) {
            ioDirection = EnumSet.noneOf(IODirection.class);
            String[] stringArray = io.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tok = stringArray[n2];
                ioDirection.add(IODirection.valueOf((String)tok));
                ++n2;
            }
        } else {
            ioDirection = EnumSet.allOf(IODirection.class);
        }
        String datasourceId = parameters.get("datasource.id");
        DataItemTargetImpl item = new DataItemTargetImpl(this.poolTracker, (DataItemInformation)new DataItemInformationBase(itemId, ioDirection), datasourceId);
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        String description = parameters.get("description");
        if (description != null) {
            ((Dictionary)properties).put("service.description", description);
        }
        this.itemPool.addService(configurationId, (Object)item, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)item);
    }
}

