/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.event.logger.internal;

import java.util.Date;
import java.util.Map;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.event.logger.internal.DataItemValueDiff;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.master.AbstractMasterHandlerImpl;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.WriteRequest;
import org.eclipse.scada.da.master.WriteRequestResult;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class MasterItemLogger
extends AbstractMasterHandlerImpl {
    private final EventProcessor eventProcessor;
    private DataItemValue lastValue;
    private boolean logSubscription;
    private boolean logValue;
    private boolean logAttributes;
    private boolean logWrites;
    private String typeWriteValue;
    private String typeWriteAttributes;
    private String typeValue;
    private String typeAttributes;
    private String typeSubscription;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterItemLogger(BundleContext context, ObjectPoolTracker<MasterItem> poolTracker, int priority) throws InvalidSyntaxException {
        super(poolTracker, priority);
        MasterItemLogger masterItemLogger = this;
        synchronized (masterItemLogger) {
            this.eventProcessor = new EventProcessor(context);
            this.eventProcessor.open();
        }
    }

    public synchronized void dispose() {
        this.eventProcessor.close();
        super.dispose();
    }

    public void dataUpdate(Map<String, Object> context, DataItemValue.Builder value) {
        if (this.logValue || this.logSubscription || this.logAttributes) {
            this.publishDiff(DataItemValueDiff.diff(this.lastValue, value.build()));
        }
        this.lastValue = value.build();
    }

    private void publishDiff(DataItemValue diff) {
        Event.EventBuilder builder;
        if (this.logSubscription && diff.getSubscriptionState() != null) {
            builder = this.createEvent(null);
            builder.attribute(Event.Fields.VALUE, (Object)diff.getSubscriptionState());
            builder.attribute(Event.Fields.EVENT_TYPE, (Object)this.typeSubscription);
            this.eventProcessor.publishEvent(builder.build());
        }
        if (this.logValue && diff.getValue() != null) {
            builder = this.createEvent(null);
            builder.attribute(Event.Fields.VALUE, diff.getValue());
            builder.attribute(Event.Fields.EVENT_TYPE, (Object)this.typeValue);
            this.eventProcessor.publishEvent(builder.build());
        }
        if (this.logAttributes && diff.getAttributes() != null && !diff.getAttributes().isEmpty()) {
            builder = this.createEvent(null);
            builder.attribute(Event.Fields.VALUE, this.formatAttributes(diff.getAttributes()));
            builder.attribute(Event.Fields.EVENT_TYPE, (Object)this.typeAttributes);
            this.eventProcessor.publishEvent(builder.build());
        }
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.logSubscription = cfg.getBoolean("logSubscription", false);
        this.logValue = cfg.getBoolean("logValue", false);
        this.logAttributes = cfg.getBoolean("logAttributes", false);
        this.logWrites = cfg.getBoolean("logWrites", false);
        this.typeWriteValue = cfg.getString("type.write.value", "WRITE");
        this.typeWriteAttributes = cfg.getString("type.write.attributes", "WRITE_ATTRIBUTES");
        this.typeValue = cfg.getString("type.change.value", "VALUE");
        this.typeAttributes = cfg.getString("type.change.attributes", "ATTRIBUTES");
        this.typeSubscription = cfg.getString("type.change.subscription", "SUBSCRIPTION");
        super.update(userInformation, parameters);
    }

    public WriteRequestResult processWrite(WriteRequest request) {
        Event.EventBuilder builder;
        if (!this.logWrites) {
            return null;
        }
        if (request.getValue() != null) {
            builder = this.createEvent(request);
            builder.attribute(Event.Fields.VALUE, request.getValue());
            builder.attribute(Event.Fields.EVENT_TYPE, (Object)this.typeWriteValue);
            this.eventProcessor.publishEvent(builder.build());
        }
        if (request.getAttributes() != null && !request.getAttributes().isEmpty()) {
            builder = this.createEvent(request);
            builder.attribute(Event.Fields.VALUE, this.formatAttributes(request.getAttributes()));
            builder.attribute(Event.Fields.EVENT_TYPE, (Object)this.typeWriteAttributes);
            this.eventProcessor.publishEvent(builder.build());
        }
        return null;
    }

    protected Variant formatAttributes(Map<String, Variant> attributes) {
        return Variant.valueOf((Object)attributes.toString());
    }

    protected Event.EventBuilder createEvent(WriteRequest request) {
        UserInformation ui;
        OperationParameters wi;
        Event.EventBuilder builder = Event.create();
        builder.sourceTimestamp(new Date());
        builder.attributes(this.eventAttributes);
        builder.attribute(Event.Fields.MONITOR_TYPE, (Object)"LOG");
        if (request != null && (wi = request.getOperationParameters()) != null && (ui = wi.getUserInformation()) != null) {
            builder.attribute(Event.Fields.ACTOR_NAME, (Object)ui.getName());
            builder.attribute(Event.Fields.ACTOR_TYPE, (Object)"USER");
        }
        return builder;
    }
}

