/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.event;

import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventService;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class EventProcessor {
    private final SingleServiceTracker<EventService> tracker;
    private final Filter filter;
    private final Queue<Event> eventQueue = new LinkedList<Event>();
    private final BundleContext context;
    private EventService service;

    public EventProcessor(BundleContext context) throws InvalidSyntaxException {
        this("(objectClass=" + EventService.class.getName() + ")", context);
    }

    public EventProcessor(Filter filter, BundleContext context) {
        this.filter = filter;
        this.context = context;
        this.tracker = new SingleServiceTracker(this.context, this.filter, (SingleServiceListener)new SingleServiceListener<EventService>(){

            public void serviceChange(ServiceReference<EventService> reference, EventService service) {
                EventProcessor.this.setService(service);
            }
        });
    }

    protected synchronized void setService(EventService service) {
        this.service = service;
        if (this.service != null) {
            this.publishStoredEvents(this.service);
        }
    }

    public EventProcessor(String filter, BundleContext context) throws InvalidSyntaxException {
        this(FrameworkUtil.createFilter((String)filter), context);
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public synchronized void publishEvent(Event event) {
        EventService service = this.service;
        if (service != null) {
            service.publishEvent(event);
        } else {
            this.eventQueue.add(event);
        }
    }

    private void publishStoredEvents(EventService service) {
        Event event = null;
        while ((event = this.eventQueue.poll()) != null) {
            service.publishEvent(event);
        }
    }
}

