/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;

public class EventMessageHelper {
    public static List<Event> fromValue(Value baseValue) {
        if (!(baseValue instanceof ListValue)) {
            return null;
        }
        ArrayList<Event> result = new ArrayList<Event>();
        ListValue value = (ListValue)baseValue;
        for (Value entryValue : value.getValues()) {
            Event event = EventMessageHelper.fromValueEvent(entryValue);
            if (event == null) continue;
            result.add(event);
        }
        return result;
    }

    public static Event fromValueEvent(Value entryValue) {
        if (!(entryValue instanceof MapValue)) {
            return null;
        }
        MapValue value = (MapValue)entryValue;
        try {
            long high = ((LongValue)value.get("id.high")).getValue();
            long low = ((LongValue)value.get("id.low")).getValue();
            UUID id = new UUID(high, low);
            Date sourceTimestamp = new Date(((LongValue)value.get("sourceTimestamp")).getValue());
            Date entryTimestamp = new Date(((LongValue)value.get("entryTimestamp")).getValue());
            Map attributes = MessageHelper.mapToAttributes((MapValue)((MapValue)value.get("attributes")));
            return Event.create().id(id).sourceTimestamp(sourceTimestamp).entryTimestamp(entryTimestamp).attributes(attributes).build();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Value toValue(Collection<Event> addedEvents) {
        if (addedEvents == null) {
            return VoidValue.INSTANCE;
        }
        ListValue result = new ListValue(addedEvents.size());
        for (Event event : addedEvents) {
            result.add(EventMessageHelper.toValue(event));
        }
        return result;
    }

    public static Value toValue(Event event) {
        MapValue value = new MapValue(5);
        value.put("id.high", (Value)new LongValue(event.getId().getMostSignificantBits()));
        value.put("id.low", (Value)new LongValue(event.getId().getLeastSignificantBits()));
        value.put("entryTimestamp", (Value)new LongValue(event.getEntryTimestamp().getTime()));
        value.put("sourceTimestamp", (Value)new LongValue(event.getSourceTimestamp().getTime()));
        value.put("attributes", (Value)MessageHelper.attributesToMap((Map)event.getAttributes()));
        return value;
    }
}

