/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.net;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;

public class MonitorMessageHelper {
    public static List<MonitorStatusInformation> fromValue(Value baseValue) {
        if (!(baseValue instanceof ListValue)) {
            return null;
        }
        ArrayList<MonitorStatusInformation> result = new ArrayList<MonitorStatusInformation>();
        ListValue value = (ListValue)baseValue;
        for (Value entryValue : value.getValues()) {
            MonitorStatusInformation entry = MonitorMessageHelper.fromValueEntry(entryValue);
            if (entry == null) continue;
            result.add(entry);
        }
        return result;
    }

    private static MonitorStatusInformation fromValueEntry(Value entryValue) {
        MonitorStatus status;
        Long lastFailTimestamp;
        Long statusTimestamp;
        String lastAknUser;
        Long lastAknTimestamp;
        Variant lastFailValue;
        Variant currentValue;
        String id;
        MapValue value;
        block11: {
            if (!(entryValue instanceof MapValue)) {
                return null;
            }
            value = (MapValue)entryValue;
            id = ((StringValue)value.get("id")).getValue();
            currentValue = MessageHelper.valueToVariant((Value)value.get("value"), null);
            lastFailValue = MessageHelper.valueToVariant((Value)value.get("lastFailValue"), null);
            lastAknTimestamp = null;
            LongValue lastAknTimestampValue = (LongValue)value.get("lastAknTimestamp");
            if (lastAknTimestampValue != null) {
                lastAknTimestamp = lastAknTimestampValue.getValue();
            }
            lastAknUser = null;
            StringValue lastAknUserValue = (StringValue)value.get("lastAknUser");
            if (lastAknUserValue != null) {
                lastAknUser = lastAknUserValue.getValue();
            }
            statusTimestamp = null;
            LongValue statusTimestampValue = (LongValue)value.get("statusTimestamp");
            if (statusTimestampValue != null) {
                statusTimestamp = statusTimestampValue.getValue();
            }
            lastFailTimestamp = null;
            LongValue lastFailTimestampValue = (LongValue)value.get("lastFailTimestamp");
            if (lastFailTimestampValue != null) {
                lastFailTimestamp = lastFailTimestampValue.getValue();
            }
            if ((status = MonitorStatus.valueOf((String)((StringValue)value.get("status")).getValue())) != null) break block11;
            return null;
        }
        try {
            Severity severity = null;
            try {
                severity = Severity.valueOf((String)((StringValue)value.get("severity")).getValue());
            }
            catch (Exception exception) {}
            Map attributes = value.get("attributes") != null ? MessageHelper.mapToAttributes((MapValue)((MapValue)value.get("attributes"))) : null;
            return new MonitorStatusInformation(id, status, statusTimestamp.longValue(), severity, currentValue, lastAknTimestamp, lastAknUser, lastFailTimestamp, lastFailValue, attributes);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Value toValue(List<MonitorStatusInformation> added) {
        ListValue result = new ListValue();
        if (added != null) {
            for (MonitorStatusInformation condition : added) {
                result.add(MonitorMessageHelper.toValue(condition));
            }
        }
        return result;
    }

    private static Value toValue(MonitorStatusInformation condition) {
        Value lastFailValue;
        MapValue value = new MapValue();
        value.put("id", (Value)new StringValue(condition.getId()));
        value.put("status", (Value)new StringValue(condition.getStatus().toString()));
        Value currentValue = MessageHelper.variantToValue((Variant)condition.getValue());
        if (currentValue != null) {
            value.put("value", currentValue);
        }
        if ((lastFailValue = MessageHelper.variantToValue((Variant)condition.getLastFailValue())) != null) {
            value.put("lastFailValue", lastFailValue);
        }
        value.put("lastAknUser", (Value)new StringValue(condition.getLastAknUser()));
        value.put("statusTimestamp", (Value)new LongValue(condition.getStatusTimestamp()));
        if (condition.getLastAknTimestamp() != null) {
            value.put("lastAknTimestamp", (Value)new LongValue(condition.getLastAknTimestamp().longValue()));
        }
        if (condition.getLastFailTimestamp() != null) {
            value.put("lastFailTimestamp", (Value)new LongValue(condition.getLastFailTimestamp().longValue()));
        }
        if (condition.getSeverity() != null) {
            value.put("severity", (Value)new StringValue(condition.getSeverity().toString()));
        }
        if (condition.getAttributes() != null) {
            value.put("attributes", (Value)MessageHelper.attributesToMap((Map)condition.getAttributes()));
        }
        return value;
    }

    public static Value toValue(Set<String> removed) {
        if (removed == null) {
            return VoidValue.INSTANCE;
        }
        ListValue result = new ListValue();
        for (String entry : removed) {
            result.add((Value)new StringValue(entry));
        }
        return result;
    }

    public static Set<String> fromValueRemoved(Value value) {
        if (!(value instanceof ListValue)) {
            return null;
        }
        HashSet<String> removed = new HashSet<String>();
        for (Value entryValue : ((ListValue)value).getValues()) {
            if (!(entryValue instanceof StringValue)) continue;
            removed.add(((StringValue)entryValue).getValue());
        }
        return removed;
    }
}

