/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.handler.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.handler.EventHandler;
import org.eclipse.scada.ae.server.handler.InjectionContext;
import org.eclipse.scada.ae.server.handler.mail.MailHandlerFactory;
import org.eclipse.scada.ae.server.handler.mail.MailRequest;
import org.eclipse.scada.ae.server.handler.mail.MailSender;
import org.eclipse.scada.base.pipe.PipeService;
import org.eclipse.scada.base.pipe.Producer;
import org.eclipse.scada.base.pipe.Worker;
import org.eclipse.scada.base.pipe.WorkerHandle;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.utils.osgi.BundleObjectInputStream;
import org.eclipse.scada.utils.str.Tables;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailEventHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(MailEventHandler.class);
    private Producer producer;
    private final Worker mailWorker;
    private WorkerHandle workerHandle;
    private final Bundle bundle;
    private MailSender sender;
    private final int maxSubjectLength = 64;
    private final int retries;

    public MailEventHandler(String id, MailSender sender, PipeService pipeService, int retries) throws Exception {
        block2: {
            this.mailWorker = new Worker(){

                public void work(byte[] data) {
                    MailEventHandler.this.handleWork(data);
                }
            };
            this.maxSubjectLength = 64;
            this.bundle = FrameworkUtil.getBundle(MailHandlerFactory.class);
            this.sender = sender;
            this.retries = retries;
            String pipeName = "mail." + id;
            try {
                this.producer = pipeService.createProducer(pipeName);
                this.workerHandle = pipeService.createWorker(pipeName, this.mailWorker);
            }
            catch (Exception exception) {
                if (this.sender == null) break block2;
                this.sender.dispose();
                this.sender = null;
            }
        }
    }

    public Event handleEvent(Event event, InjectionContext context) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(this.makeRequest(event));
            os.close();
            this.producer.publish(bos.toByteArray(), this.retries);
        }
        catch (Exception e) {
            logger.warn("Failed to process event", (Throwable)e);
        }
        return event;
    }

    private MailRequest makeRequest(Event event) throws IOException {
        String subject;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Variant message = (Variant)event.getAttributes().get(Event.Fields.MESSAGE.getName());
        String mainMessage = null;
        if (message != null && message.isString()) {
            mainMessage = message.asString(null);
            pw.println(message.asString(""));
            pw.println();
        }
        ArrayList keys = new ArrayList(event.getAttributes().keySet());
        Collections.sort(keys);
        LinkedList rows = new LinkedList();
        for (String key : keys) {
            LinkedList<String> row = new LinkedList<String>();
            row.add(key);
            row.add("" + event.getAttributes().get(key));
            rows.add(row);
        }
        Tables.showTable((PrintWriter)pw, Arrays.asList("Key", "Value"), rows, (int)1);
        pw.close();
        if (mainMessage != null) {
            subject = String.format("Event message: %s", message);
            if (64 > 0 && subject.length() > 64) {
                subject = String.valueOf(subject.substring(0, 64)) + "...";
            }
        } else {
            subject = String.format("Event message", new Object[0]);
        }
        MailRequest request = new MailRequest("Event message", sw.toString());
        return request;
    }

    public void dispose() {
        logger.info("Disposing");
        if (this.workerHandle != null) {
            this.workerHandle.close();
            this.workerHandle = null;
        }
        if (this.sender != null) {
            this.sender.dispose();
            this.sender = null;
        }
    }

    protected void handleWork(byte[] data) {
        Object o;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BundleObjectInputStream is = new BundleObjectInputStream((InputStream)new ByteArrayInputStream(data), this.bundle);){
                o = is.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to decode worker request", (Throwable)e);
            return;
        }
        if (o instanceof MailRequest) {
            try {
                this.processWork((MailRequest)o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void processWork(MailRequest request) throws Exception {
        this.sender.send(request.getSubject(), request.getText());
    }
}

