/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca;

import org.eclipse.scada.ca.Factory;
import org.eclipse.scada.ca.data.FactoryState;
import org.eclipse.scada.utils.lang.Immutable;

@Immutable
public class FactoryEvent {
    private final Factory factory;
    private final Type type;
    private final FactoryState state;

    public FactoryEvent(Type type, Factory factory, FactoryState state) {
        this.type = type;
        this.factory = factory;
        this.state = state;
    }

    public FactoryState getState() {
        return this.state;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case STATE: {
                return String.format("%s -> %s : %s", new Object[]{this.factory.getId(), this.type, this.state});
            }
        }
        return String.format("%s -> %s", new Object[]{this.factory.getId(), this.type});
    }

    public static enum Type {
        STATE,
        ADDED,
        REMOVED;

    }
}

