/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.client.FolderSyncController;
import org.eclipse.scada.da.client.FolderWatcher;
import org.eclipse.scada.da.core.Location;

public class FolderManager
implements ConnectionStateListener {
    protected Connection connection = null;
    private final Map<Location, FolderSyncController> folderListeners = new HashMap<Location, FolderSyncController>();

    public FolderManager(Connection connection) {
        this.connection = connection;
        this.connection.addConnectionStateListener(this);
    }

    public void dispose() {
        this.connection.removeConnectionStateListener(this);
        this.disconnectAllFolders();
        this.connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFolderListener(FolderListener listener, Location location) {
        Map<Location, FolderSyncController> map = this.folderListeners;
        synchronized (map) {
            if (!this.folderListeners.containsKey(location)) {
                this.folderListeners.put(location, new FolderSyncController(this.connection, new Location(location)));
            }
            FolderSyncController controller = this.folderListeners.get(location);
            controller.addListener(listener);
        }
    }

    public void addFolderWatcher(FolderWatcher watcher) {
        this.addFolderListener(watcher, watcher.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderListener(FolderListener listener, Location location) {
        Map<Location, FolderSyncController> map = this.folderListeners;
        synchronized (map) {
            FolderSyncController controller = this.folderListeners.get(location);
            if (controller == null) {
                return;
            }
            controller.removeListener(listener);
        }
    }

    public void removeFolderWatcher(FolderWatcher watcher) {
        this.removeFolderListener(watcher, watcher.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resyncAllFolders() {
        Map<Location, FolderSyncController> map = this.folderListeners;
        synchronized (map) {
            for (Map.Entry<Location, FolderSyncController> entry : this.folderListeners.entrySet()) {
                entry.getValue().resync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAllFolders() {
        Map<Location, FolderSyncController> map = this.folderListeners;
        synchronized (map) {
            for (final Map.Entry<Location, FolderSyncController> entry : this.folderListeners.entrySet()) {
                this.connection.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ((FolderSyncController)entry.getValue()).disconnected();
                    }
                });
            }
        }
    }

    public void stateChange(org.eclipse.scada.core.client.Connection connection, ConnectionState state, Throwable error) {
        switch (state) {
            case BOUND: {
                this.resyncAllFolders();
                break;
            }
            case CLOSED: {
                this.disconnectAllFolders();
                break;
            }
        }
    }
}

