/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.delta;

import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.base.AbstractDataSourceHandler;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaDataSource
extends AbstractDataSourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeltaDataSource.class);
    private final Executor executor;
    private Double lastValue;

    public DeltaDataSource(Executor executor, ObjectPoolTracker<DataSource> tracker) {
        super(tracker);
        this.executor = executor;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return new InstantErrorFuture((Throwable)new OperationException("Operation not supported"));
    }

    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        return new InstantErrorFuture((Throwable)new OperationException("Operation not supported"));
    }

    public synchronized void update(Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.setDataSource(cfg.getStringChecked("datasource.id", "'datasource.id' must be set"));
    }

    protected void stateChanged(DataItemValue value) {
        logger.trace("Value change - lastValue: {}, change: {}", (Object)this.lastValue, (Object)value);
        Double newValue = value.getValue().asDouble(null);
        if (this.lastValue == null) {
            this.lastValue = newValue;
            this.updateNewValue(null);
        } else {
            if (newValue != null) {
                double delta = newValue - this.lastValue;
                this.updateNewValue(delta);
            } else {
                this.lastValue = null;
                this.updateNewValue(null);
            }
            this.lastValue = newValue;
        }
    }

    private void updateNewValue(Double delta) {
        DataItemValue.Builder builder = new DataItemValue.Builder();
        builder.setValue(Variant.valueOf((Object)delta));
        if (delta == null) {
            builder.setAttribute("value.error", Variant.TRUE);
            this.updateData(builder.build());
        } else {
            this.updateData(builder.build());
            builder.setValue(Variant.valueOf((int)0));
            this.updateData(builder.build());
        }
    }
}

