/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.delta;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.delta.DeltaDataSource;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class DeltaDataSourceFactory
extends AbstractServiceConfigurationFactory<DeltaDataSource> {
    private final ExecutorService executor;
    private final ObjectPoolImpl<DataSource> objectPool;
    private final ServiceRegistration<?> poolRegistration;
    private final ObjectPoolTracker<DataSource> tracker;

    public DeltaDataSourceFactory(BundleContext context, ExecutorService executor, ObjectPoolTracker<DataSource> tracker) {
        super(context);
        this.executor = executor;
        this.tracker = tracker;
        this.objectPool = new ObjectPoolImpl();
        this.poolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.objectPool, DataSource.class);
    }

    public synchronized void dispose() {
        this.poolRegistration.unregister();
        this.objectPool.dispose();
        super.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<DeltaDataSource> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        DeltaDataSource service = new DeltaDataSource(this.executor, this.tracker);
        service.update(parameters);
        this.objectPool.addService(configurationId, (Object)service, null);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)service);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, DeltaDataSource service) {
        this.objectPool.removeService(configurationId, (Object)service);
    }

    protected AbstractServiceConfigurationFactory.Entry<DeltaDataSource> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<DeltaDataSource> entry, Map<String, String> parameters) throws Exception {
        ((DeltaDataSource)((Object)entry.getService())).update(parameters);
        return null;
    }
}

