/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.movingaverage;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.eclipse.scada.da.datasource.SingleDataSourceTracker;
import org.eclipse.scada.da.datasource.base.DataInputSource;
import org.eclipse.scada.da.datasource.data.DataItemValueLight;
import org.eclipse.scada.da.datasource.data.DataItemValueRange;
import org.eclipse.scada.da.datasource.movingaverage.Activator;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovingAverageDataSource
implements DataSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(MovingAverageDataSource.class);
    private DataItemValueRange valueRange;
    private final ScheduledExecutorService scheduler;
    private SingleDataSourceTracker dataSourceTracker;
    private String dataSourceId;
    private DataSource dataSource;
    private final String configurationId;
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final ObjectPoolImpl<DataSource> dsObjectPool;
    private ScheduledFuture<?> triggerFuture;
    private long trigger;
    private long range;
    private long nullrange;
    private boolean triggerOnly = false;
    private final DataInputSource minDataSource;
    private final DataInputSource maxDataSource;
    private final DataInputSource arithmeticDataSource;
    private final DataInputSource medianDataSource;
    private final DataInputSource weightedDataSource;
    private final DataInputSource deviationArithmeticDataSource;
    private final DataInputSource deviationWeightedDataSource;

    public MovingAverageDataSource(String configurationId, ScheduledExecutorService scheduler, ObjectPoolTracker<DataSource> poolTracker, ObjectPoolImpl<DataSource> dsObjectPool) throws InvalidSyntaxException {
        this.scheduler = scheduler;
        this.valueRange = new DataItemValueRange(0L);
        this.configurationId = configurationId;
        this.poolTracker = poolTracker;
        this.dsObjectPool = dsObjectPool;
        this.minDataSource = new DataInputSource((Executor)scheduler);
        this.maxDataSource = new DataInputSource((Executor)scheduler);
        this.arithmeticDataSource = new DataInputSource((Executor)scheduler);
        this.medianDataSource = new DataInputSource((Executor)scheduler);
        this.weightedDataSource = new DataInputSource((Executor)scheduler);
        this.deviationArithmeticDataSource = new DataInputSource((Executor)scheduler);
        this.deviationWeightedDataSource = new DataInputSource((Executor)scheduler);
        String id = String.valueOf(this.configurationId) + ".min";
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.minDataSource, null);
        id = String.valueOf(this.configurationId) + ".max";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.maxDataSource, null);
        id = String.valueOf(this.configurationId) + ".arithmetic";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.arithmeticDataSource, null);
        id = String.valueOf(this.configurationId) + ".median";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.medianDataSource, null);
        id = String.valueOf(this.configurationId) + ".weighted";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.weightedDataSource, null);
        id = String.valueOf(this.configurationId) + ".deviationArithmetic";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.deviationArithmeticDataSource, null);
        id = String.valueOf(this.configurationId) + ".deviationWeighted";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.deviationWeightedDataSource, null);
    }

    public void dispose() {
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".min", (Object)this.minDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".max", (Object)this.maxDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".arithmetic", (Object)this.arithmeticDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".median", (Object)this.medianDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".weighted", (Object)this.weightedDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".deviationArithmetic", (Object)this.deviationArithmeticDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".deviationWeighted", (Object)this.deviationWeightedDataSource);
    }

    public void update(Map<String, String> parameters) throws InvalidSyntaxException {
        if (this.triggerFuture != null) {
            this.triggerFuture.cancel(false);
            this.triggerFuture = null;
        }
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        try {
            this.dataSourceId = cfg.getStringChecked("datasource.id", "'datasource.id' must be set");
            this.trigger = cfg.getLongChecked("trigger", "'trigger' must be set");
            this.range = cfg.getLongChecked("range", "'range' must be set");
            this.nullrange = cfg.getLongChecked("nullRange", "'nullRange' must be set");
            this.triggerOnly = cfg.getBoolean("triggerOnly", false);
        }
        catch (IllegalArgumentException e) {
            this.updateAverage(new AverageValues());
            throw e;
        }
        this.handleChange();
    }

    private void handleChange() throws InvalidSyntaxException {
        this.valueRange = new DataItemValueRange(this.range * 1000L);
        this.updateDataSource();
        this.triggerFuture = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    MovingAverageDataSource.this.valueRange.checkRange();
                    MovingAverageDataSource.this.updateValues();
                }
                catch (Exception e) {
                    logger.error("failed to run checkRange () or call updateValues ()", (Throwable)e);
                }
            }
        }, this.trigger, this.trigger, TimeUnit.SECONDS);
        try {
            this.updateValues();
        }
        catch (Exception e) {
            logger.error("failed to update values", (Throwable)e);
        }
    }

    public void stateChanged(DataItemValue value) {
        try {
            this.valueRange.add(DataItemValueLight.valueOf((DataItemValue)value));
            if (!this.triggerOnly) {
                this.updateValues();
            }
        }
        catch (Exception e) {
            logger.error("failed to add DataItemValue or to call updateValues ()", (Throwable)e);
        }
    }

    private void updateValues() {
        DataItemValueRange.DataItemValueRangeState state = this.valueRange.getState();
        AverageValues average = new AverageValues();
        if (state.getSize() == 0) {
            if (state.getFirstValue().hasValue()) {
                average.min = state.getFirstValue().getValue().asDouble(Double.valueOf(0.0));
                average.max = state.getFirstValue().getValue().asDouble(Double.valueOf(0.0));
                average.arithmetic = state.getFirstValue().getValue().asDouble(Double.valueOf(0.0));
                average.median = state.getFirstValue().getValue().asDouble(Double.valueOf(0.0));
                average.weighted = state.getFirstValue().getValue().asDouble(Double.valueOf(0.0));
                average.deviationArithmetic = 0.0;
                average.deviationWeighted = 0.0;
            }
        } else {
            DataItemValueLight lastValue = new DataItemValueLight(state.getFirstValue().getValue(), state.getFirstValue().getSubscriptionState(), state.getOldestPossibleTimestamp(), state.getFirstValue().isManual(), state.getFirstValue().isError());
            Iterator it = state.getValues().iterator();
            int i = 0;
            while (i < state.getSize() + 1) {
                if (i < state.getSize()) {
                    DataItemValueLight divl = (DataItemValueLight)it.next();
                    long currentRange = divl.getTimestamp() - lastValue.getTimestamp();
                    this.calculateForRange(average, currentRange, lastValue.getValue(), lastValue.isManual(), lastValue.isError(), lastValue.getSubscriptionState() != SubscriptionState.DISCONNECTED);
                    lastValue = divl;
                } else {
                    long currentRange = state.getOldestPossibleTimestamp() + this.valueRange.getRange() - lastValue.getTimestamp();
                    this.calculateForRange(average, currentRange, lastValue.getValue(), lastValue.isManual(), lastValue.isError(), lastValue.getSubscriptionState() != SubscriptionState.DISCONNECTED);
                }
                ++i;
            }
            if (average.values.size() > 0) {
                average.arithmetic = average.arithmetic / (double)average.values.size();
            }
            if (average.values.size() > 0) {
                average.median = average.values.get(average.values.size() / 2);
            }
            if (average.weighted != null) {
                average.weighted = average.weighted / (double)this.valueRange.getRange();
            }
            if (!average.values.isEmpty()) {
                double da = 0.0;
                double dw = 0.0;
                Iterator iterator = average.values.iterator();
                while (iterator.hasNext()) {
                    double v = (Double)iterator.next();
                    da += Math.pow(v - average.arithmetic, 2.0);
                    dw += Math.pow(v - average.weighted, 2.0);
                }
                average.deviationArithmetic = Math.sqrt(da / (double)average.values.size());
                average.deviationWeighted = Math.sqrt(dw / (double)average.values.size());
            }
            if (average.nullRange >= this.nullrange * 1000L) {
                average.arithmetic = null;
                average.median = null;
                average.weighted = null;
                average.deviationArithmetic = null;
                average.deviationWeighted = null;
            }
        }
        this.updateAverage(average);
    }

    private void updateAverage(AverageValues average) {
        DataItemValue.Builder divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)average.min));
        this.setAdditionalAttributes(divb, average);
        this.minDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)average.max));
        this.setAdditionalAttributes(divb, average);
        this.maxDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)average.arithmetic));
        this.setAdditionalAttributes(divb, average);
        this.arithmeticDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)average.median));
        this.setAdditionalAttributes(divb, average);
        this.medianDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)average.weighted));
        this.setAdditionalAttributes(divb, average);
        this.weightedDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)average.deviationArithmetic));
        this.setAdditionalAttributes(divb, average);
        this.deviationArithmeticDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)average.deviationWeighted));
        this.setAdditionalAttributes(divb, average);
        this.deviationWeightedDataSource.setValue(divb.build());
    }

    private void setAdditionalAttributes(DataItemValue.Builder divb, AverageValues average) {
        if (average.manualRange > 0L) {
            divb.setAttribute(String.valueOf(Activator.getContext().getBundle().getSymbolicName()) + ".manual", Variant.valueOf((boolean)true));
        }
        if (average.errorRange > this.nullrange * 1000L) {
            divb.setAttribute(String.valueOf(Activator.getContext().getBundle().getSymbolicName()) + ".error", Variant.valueOf((boolean)true));
        }
        if (average.disconnectedRange > this.nullrange * 1000L) {
            divb.setSubscriptionState(SubscriptionState.DISCONNECTED);
        }
    }

    private void calculateForRange(AverageValues average, long currentRange, Variant value, boolean isManual, boolean isError, boolean isDisconnected) {
        if (!value.isNumber()) {
            average.nullRange += currentRange;
        } else {
            double d = value.asDouble(Double.valueOf(0.0));
            average.min = average.min == null ? d : average.min;
            average.max = average.max == null ? d : average.max;
            average.arithmetic = average.arithmetic == null ? 0.0 : average.arithmetic;
            average.weighted = average.weighted == null ? 0.0 : average.weighted;
            average.min = d < average.min ? d : average.min;
            average.max = d > average.max ? d : average.max;
            average.arithmetic = average.arithmetic + d;
            average.values.add(d);
            average.weighted = average.weighted + d * (double)currentRange;
        }
        if (isManual) {
            average.manualRange += currentRange;
        }
        if (isError) {
            average.errorRange += currentRange;
        }
        if (isDisconnected) {
            average.disconnectedRange += currentRange;
        }
    }

    private void updateDataSource() throws InvalidSyntaxException {
        logger.debug("updateDataSource ()");
        if (this.dataSourceTracker != null) {
            this.dataSourceTracker.close();
            this.dataSourceTracker = null;
        }
        if (this.dataSourceId != null) {
            logger.debug("track datasource {}", (Object)this.dataSourceId);
            this.dataSourceTracker = new SingleDataSourceTracker(this.poolTracker, this.dataSourceId, new SingleDataSourceTracker.ServiceListener(){

                public void dataSourceChanged(DataSource dataSource) {
                    MovingAverageDataSource.this.setDataSource(dataSource);
                }
            });
            this.dataSourceTracker.open();
        }
    }

    private void setDataSource(DataSource dataSource) {
        logger.info("Set data source item: {}", (Object)dataSource);
        if (this.dataSource != null) {
            this.dataSource.removeListener((DataSourceListener)this);
        }
        this.dataSource = dataSource;
        if (this.dataSource != null) {
            this.dataSource.addListener((DataSourceListener)this);
        }
    }

    private class AverageValues {
        public Double min;
        public Double max;
        public Double arithmetic;
        public Double median;
        public Double weighted;
        public Double deviationArithmetic;
        public Double deviationWeighted;
        public long nullRange = 0L;
        public long manualRange = 0L;
        public long errorRange = 0L;
        public long disconnectedRange = 0L;
        public LinkedList<Double> values = new LinkedList();

        private AverageValues() {
        }
    }
}

