/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.chain;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.ChainProcessEntry;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public abstract class DataItemInputOutputChained
extends DataItemInputChained {
    public DataItemInputOutputChained(DataItemInformation di, Executor executor) {
        super(di, executor);
    }

    public DataItemInputOutputChained(String id, Executor executor) {
        this(new DataItemInformationBase(id, EnumSet.of(IODirection.INPUT, IODirection.OUTPUT)), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        DataItemInputOutputChained dataItemInputOutputChained = this;
        synchronized (dataItemInputOutputChained) {
            Collection<ChainProcessEntry> chain = this.getChainCopy();
            HashMap<String, Variant> primaryAttributes = new HashMap<String, Variant>(this.primaryAttributes);
            for (ChainProcessEntry entry : chain) {
                Variant newValue;
                if (!entry.getWhen().contains(IODirection.OUTPUT) || (newValue = entry.getWhat().process(value, primaryAttributes)) == null) continue;
                value = newValue;
            }
        }
        return this.startWriteCalculatedValue(value, operationParameters);
    }

    protected abstract NotifyFuture<WriteResult> startWriteCalculatedValue(Variant var1, OperationParameters var2);
}

