/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.subscription.SubscriptionInformation;
import org.eclipse.scada.core.subscription.SubscriptionSource;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.ItemListener;
import org.eclipse.scada.da.server.common.impl.DataItemSubscriptionListener;
import org.eclipse.scada.da.server.common.impl.stats.HiveEventListener;

public class DataItemSubscriptionSource
implements SubscriptionSource<String>,
ItemListener {
    private DataItem dataItem = null;
    private final Set<DataItemSubscriptionListener> listeners = new HashSet<DataItemSubscriptionListener>(1);
    private boolean bound = false;
    private Variant cacheValue = null;
    private final Map<String, Variant> cacheAttributes = new HashMap<String, Variant>();
    private final HiveEventListener hiveEventListener;
    private final Executor executor;

    public DataItemSubscriptionSource(Executor executor, DataItem dataItem, HiveEventListener hiveEventListener) {
        this.dataItem = dataItem;
        this.hiveEventListener = hiveEventListener;
        this.executor = executor;
    }

    private synchronized void bind() {
        if (this.bound) {
            return;
        }
        this.bound = true;
        final DataItem item = this.dataItem;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                item.setListener(DataItemSubscriptionSource.this);
            }
        });
    }

    private synchronized void unbind() {
        if (!this.bound) {
            return;
        }
        this.cacheValue = null;
        this.cacheAttributes.clear();
        this.bound = false;
        final DataItem item = this.dataItem;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                item.setListener(null);
            }
        });
    }

    public synchronized void addListener(Collection<SubscriptionInformation<String>> listeners) {
        for (final SubscriptionInformation<String> listener : listeners) {
            this.listeners.add((DataItemSubscriptionListener)listener.getListener());
            final DataItem dataItem = this.dataItem;
            final Variant cacheValue = this.cacheValue;
            final HashMap<String, Variant> attributes = new HashMap<String, Variant>(this.cacheAttributes);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((DataItemSubscriptionListener)listener.getListener()).dataChanged(dataItem, cacheValue, attributes, true);
                }
            });
        }
        if (!this.listeners.isEmpty()) {
            this.bind();
        }
    }

    public synchronized void removeListener(Collection<SubscriptionInformation<String>> listeners) {
        for (SubscriptionInformation<String> listener : listeners) {
            this.listeners.remove(listener.getListener());
        }
        if (this.listeners.isEmpty()) {
            this.unbind();
        }
    }

    public boolean supportsListener(SubscriptionInformation<String> subscriptionInformation) {
        return subscriptionInformation.getListener() instanceof DataItemSubscriptionListener;
    }

    @Override
    public synchronized void dataChanged(final DataItem item, final Variant variant, final Map<String, Variant> attributes, final boolean cache) {
        DataItemSubscriptionListener[] listeners;
        if (attributes != null) {
            AttributesHelper.mergeAttributes(this.cacheAttributes, attributes);
        }
        if (variant != null) {
            this.cacheValue = variant;
        }
        if ((listeners = this.listeners.toArray(new DataItemSubscriptionListener[this.listeners.size()])).length > 0) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    DataItemSubscriptionSource.fireDataChange(item, variant, attributes, cache, listeners);
                }
            });
        }
        if (this.hiveEventListener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    DataItemSubscriptionSource.this.updateStats(item, variant, attributes, cache);
                }
            });
        }
    }

    private static void fireDataChange(DataItem item, Variant variant, Map<String, Variant> attributes, boolean cache, DataItemSubscriptionListener[] listeners) {
        DataItemSubscriptionListener[] dataItemSubscriptionListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            DataItemSubscriptionListener listener = dataItemSubscriptionListenerArray[n2];
            listener.dataChanged(item, variant, attributes, cache);
            ++n2;
        }
    }

    private void updateStats(DataItem item, Variant variant, Map<String, Variant> attributes, boolean cache) {
        if (variant != null) {
            this.hiveEventListener.valueChanged(item, variant, cache);
        }
        if (attributes != null) {
            this.hiveEventListener.attributesChanged(item, attributes.size());
        }
    }
}

