/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.item.factory;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.chain.WriteHandlerItem;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;

public class CommonItemFactory
implements ItemFactory {
    protected static final String DEFAULT_ID_DELIMITER = ".";
    private String baseId = null;
    private String idDelimiter = ".";
    protected Map<String, DataItem> itemMap = new HashMap<String, DataItem>();
    private final Set<ItemFactory> factorySet = new HashSet<ItemFactory>();
    private boolean disposed = false;
    private final CommonItemFactory parentItemFactory;
    private final Executor executor;

    public CommonItemFactory(Executor executor) {
        this(executor, null, null, DEFAULT_ID_DELIMITER);
    }

    public CommonItemFactory(Executor executor, CommonItemFactory parentItemFactory, String baseId, String idDelimiter) {
        this.executor = executor;
        this.parentItemFactory = parentItemFactory;
        if (parentItemFactory != null) {
            parentItemFactory.addSubFactory(this);
        }
        this.idDelimiter = idDelimiter;
        if (this.idDelimiter == null) {
            this.idDelimiter = DEFAULT_ID_DELIMITER;
        }
        this.baseId = parentItemFactory != null ? String.valueOf(parentItemFactory.getBaseId()) + this.idDelimiter + baseId : baseId;
    }

    public void setIdDelimiter(String idDelimiter) {
        this.idDelimiter = idDelimiter == null ? DEFAULT_ID_DELIMITER : idDelimiter;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    protected String generateId(String localId) {
        if (this.baseId == null) {
            return localId;
        }
        return String.valueOf(this.baseId) + this.idDelimiter + localId;
    }

    private void registerItem(DataItem newItem) {
        DataItem oldItem = this.itemMap.put(newItem.getInformation().getName(), newItem);
        if (oldItem != null) {
            this.disposeItem(oldItem);
        }
    }

    protected DataItemCommand constructCommand(String localId) {
        DataItemCommand commandItem = new DataItemCommand(this.generateId(localId), this.executor);
        this.registerItem(commandItem);
        return commandItem;
    }

    protected DataItemInputChained constructInput(String localId) {
        DataItemInputChained inputItem = new DataItemInputChained(this.generateId(localId), this.executor);
        this.registerItem(inputItem);
        return inputItem;
    }

    protected WriteHandlerItem constructInputOutput(String localId, WriteHandler writeHandler) {
        WriteHandlerItem ioItem = new WriteHandlerItem(this.generateId(localId), writeHandler, this.executor);
        this.registerItem(ioItem);
        return ioItem;
    }

    protected WriteHandlerItem constructWriteHandler(String localId, WriteHandler writeHandler) {
        WriteHandlerItem item = new WriteHandlerItem((DataItemInformation)new DataItemInformationBase(this.generateId(localId), EnumSet.of(IODirection.OUTPUT)), writeHandler, this.executor);
        this.registerItem(item);
        return item;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.disposed = true;
        if (this.parentItemFactory != null) {
            this.parentItemFactory.removeSubFactory(this);
        }
        this.disposeAllItems();
        HashSet<ItemFactory> factoryMap = new HashSet<ItemFactory>(this.factorySet);
        for (ItemFactory factory : factoryMap) {
            factory.dispose();
        }
        this.factorySet.clear();
    }

    @Override
    public void disposeAllItems() {
        this.itemMap.clear();
    }

    @Override
    public void disposeItem(DataItem item) {
        this.itemMap.remove(item.getInformation().getName());
    }

    @Override
    public DataItemCommand createCommand(String localId, Map<String, Variant> properties) {
        return this.constructCommand(localId);
    }

    @Override
    public DataItemInputChained createInput(String localId, Map<String, Variant> properties) {
        return this.constructInput(localId);
    }

    @Override
    public WriteHandlerItem createOutput(String localId, Map<String, Variant> properties, WriteHandler writeHandler) {
        return this.constructWriteHandler(localId, writeHandler);
    }

    @Override
    public WriteHandlerItem createInputOutput(String localId, Map<String, Variant> properties, WriteHandler writeHandler) {
        return this.constructInputOutput(localId, writeHandler);
    }

    public String getBaseId() {
        return this.baseId;
    }

    public boolean addSubFactory(ItemFactory itemFactory) {
        return this.factorySet.add(itemFactory);
    }

    public boolean removeSubFactory(ItemFactory itemFactory) {
        return this.factorySet.remove(itemFactory);
    }
}

