/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.sfp;

import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.protocol.sfp.Sessions;
import org.eclipse.scada.protocol.sfp.messages.BrowseAdded;
import org.eclipse.scada.protocol.sfp.messages.DataType;
import org.eclipse.scada.protocol.sfp.messages.DataUpdate;
import org.eclipse.scada.protocol.sfp.messages.Hello;
import org.eclipse.scada.protocol.sfp.messages.ReadAll;
import org.eclipse.scada.protocol.sfp.messages.SubscribeBrowse;
import org.eclipse.scada.protocol.sfp.messages.UnsubscribeBrowse;
import org.eclipse.scada.protocol.sfp.messages.Welcome;
import org.eclipse.scada.protocol.sfp.messages.WriteCommand;
import org.eclipse.scada.protocol.sfp.messages.WriteResult;

public class ProtocolEncoderImpl
implements ProtocolEncoder {
    private final Charset defaultCharset = Charset.forName("UTF-8");

    public void dispose(IoSession session) throws Exception {
    }

    protected IoBuffer createMessage(IoSession session, byte command, boolean longMessage) {
        IoBuffer data = IoBuffer.allocate((int)3);
        data.setAutoExpand(true);
        if (Sessions.isLittleEndian(session)) {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        data.put((byte)18);
        data.put((byte)2);
        data.put(command);
        if (longMessage) {
            data.putShort((short)0);
        }
        return data;
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        IoBuffer data = null;
        if (message instanceof Hello) {
            data = this.createMessage(session, (byte)1, true);
            data.put((byte)1);
            data.putShort(((Hello)message).getNodeId());
            data.putEnumSetShort(((Hello)message).getFeatures());
            data.putUnsignedShort(3, data.position() - 3);
        } else if (message instanceof Welcome) {
            data = this.createMessage(session, (byte)2, true);
            data.putEnumSetShort(((Welcome)message).getFeatures());
            this.encodeProperties(data, ((Welcome)message).getProperties());
            data.putUnsignedShort(3, data.position() - 3);
        } else if (message instanceof ReadAll) {
            data = this.createMessage(session, (byte)3, false);
        } else if (message instanceof DataUpdate) {
            data = this.createMessage(session, (byte)4, true);
            data.putUnsignedShort(((DataUpdate)message).getEntries().size());
            for (DataUpdate.Entry entry : ((DataUpdate)message).getEntries()) {
                this.encodeEntry(session, data, entry);
            }
            data.putUnsignedShort(3, data.position() - 3);
        } else if (message instanceof SubscribeBrowse) {
            data = this.createMessage(session, (byte)5, false);
        } else if (message instanceof UnsubscribeBrowse) {
            data = this.createMessage(session, (byte)6, false);
        } else if (message instanceof BrowseAdded) {
            data = this.createMessage(session, (byte)7, true);
            this.encodeBrowseUpdate(session, message, data);
            data.putUnsignedShort(3, data.position() - 3);
        } else if (message instanceof WriteCommand) {
            data = this.createMessage(session, (byte)8, true);
            data.putUnsignedShort(((WriteCommand)message).getRegisterNumber());
            data.putInt(((WriteCommand)message).getOperationId());
            this.encodeVariant(session, data, ((WriteCommand)message).getValue());
            data.putUnsignedShort(3, data.position() - 3);
        } else if (message instanceof WriteResult) {
            data = this.createMessage(session, (byte)9, true);
            data.putInt(((WriteResult)message).getOperationId());
            data.putUnsignedShort(((WriteResult)message).getErrorCode());
            data.putPrefixedString((CharSequence)((WriteResult)message).getErrorMessage(), Sessions.getCharsetEncoder(session));
            data.putUnsignedShort(3, data.position() - 3);
        }
        if (data == null) {
            throw new ProtocolCodecException(String.format("Message %s is not supported", message.getClass().getName()));
        }
        data.flip();
        out.write((Object)data);
    }

    private void encodeBrowseUpdate(IoSession session, Object message, IoBuffer data) throws ProtocolCodecException {
        data.putUnsignedShort(((BrowseAdded)message).getEntries().size());
        CharsetEncoder encoder = Sessions.getCharsetEncoder(session);
        for (BrowseAdded.Entry entry : ((BrowseAdded)message).getEntries()) {
            data.putUnsignedShort(entry.getRegister());
            data.put(entry.getDataType().getDataType());
            data.putEnumSet(entry.getFlags());
            try {
                data.putPrefixedString((CharSequence)entry.getName(), encoder);
                data.putPrefixedString((CharSequence)entry.getDescription(), encoder);
                data.putPrefixedString((CharSequence)entry.getUnit(), encoder);
            }
            catch (CharacterCodingException e) {
                throw new ProtocolCodecException((Throwable)e);
            }
        }
    }

    private void encodeProperties(IoBuffer data, Map<String, String> properties) throws ProtocolCodecException {
        CharsetEncoder encoder = this.defaultCharset.newEncoder();
        data.putUnsignedShort(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            try {
                data.putPrefixedString((CharSequence)entry.getKey(), encoder);
                data.putPrefixedString((CharSequence)entry.getValue(), encoder);
            }
            catch (CharacterCodingException e) {
                throw new ProtocolCodecException((Throwable)e);
            }
        }
    }

    private void encodeVariant(IoSession session, IoBuffer data, Variant value) throws ProtocolCodecException {
        if (value == null) {
            data.put(DataType.DEAD.getDataType());
        } else if (value.isNull()) {
            data.put(DataType.NULL.getDataType());
        } else if (value.isBoolean()) {
            data.put(DataType.BOOLEAN.getDataType());
            data.put((byte)(value.asBoolean() ? 255 : 0));
        } else if (value.isInteger()) {
            data.put(DataType.INT32.getDataType());
            data.putInt(value.asInteger(null).intValue());
        } else if (value.isLong()) {
            data.put(DataType.INT64.getDataType());
            data.putLong(value.asLong(null).longValue());
        } else if (value.isDouble()) {
            data.put(DataType.DOUBLE.getDataType());
            data.putDouble(value.asDouble(null).doubleValue());
        } else if (value.isString()) {
            data.put(DataType.STRING.getDataType());
            try {
                data.putPrefixedString((CharSequence)value.asString(null), Sessions.getCharsetEncoder(session));
            }
            catch (CharacterCodingException e) {
                throw new ProtocolCodecException((Throwable)e);
            }
        }
    }

    private void encodeEntry(IoSession session, IoBuffer data, DataUpdate.Entry entry) throws ProtocolCodecException {
        data.putUnsignedShort(entry.getRegister());
        data.put(entry.getMissedUpdates());
        data.putLong(entry.getTimestamp());
        data.putEnumSetShort(entry.getStates());
        this.encodeVariant(session, data, entry.getValue());
    }
}

